/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.adventure.audience;

import java.util.Collection;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.sound.SoundStop;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.title.TitlePart;
import net.minestom.server.MinecraftServer;
import net.minestom.server.advancements.Notification;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Player;
import net.minestom.server.message.ChatPosition;
import net.minestom.server.message.Messenger;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.ActionBarPacket;
import net.minestom.server.network.packet.server.play.ClearTitlesPacket;
import net.minestom.server.network.packet.server.play.PlayerListHeaderAndFooterPacket;
import net.minestom.server.utils.PacketSendingUtils;

public interface PacketGroupingAudience
extends ForwardingAudience {
    public static PacketGroupingAudience of(Collection<Player> players) {
        return () -> players;
    }

    public Collection<Player> getPlayers();

    default public void sendGroupedPacket(ServerPacket packet) {
        PacketSendingUtils.sendGroupedPacket(this.getPlayers(), packet);
    }

    @Override
    @Deprecated
    default public void sendMessage(Identity source, Component message, MessageType type) {
        Messenger.sendMessage(this.getPlayers(), message, ChatPosition.fromMessageType(type), source.uuid());
    }

    @Override
    default public void sendActionBar(Component message) {
        this.sendGroupedPacket(new ActionBarPacket(message));
    }

    @Override
    default public void sendPlayerListHeaderAndFooter(Component header, Component footer) {
        this.sendGroupedPacket(new PlayerListHeaderAndFooterPacket(header, footer));
    }

    @Override
    default public <T> void sendTitlePart(TitlePart<T> part, T value) {
        this.sendGroupedPacket(AdventurePacketConvertor.createTitlePartPacket(part, value));
    }

    @Override
    default public void clearTitle() {
        this.sendGroupedPacket(new ClearTitlesPacket(false));
    }

    @Override
    default public void resetTitle() {
        this.sendGroupedPacket(new ClearTitlesPacket(true));
    }

    @Override
    default public void showBossBar(BossBar bar) {
        MinecraftServer.getBossBarManager().addBossBar(this.getPlayers(), bar);
    }

    @Override
    default public void hideBossBar(BossBar bar) {
        MinecraftServer.getBossBarManager().removeBossBar(this.getPlayers(), bar);
    }

    default public void playSound(Sound sound, Point point) {
        this.playSound(sound, point.x(), point.y(), point.z());
    }

    @Override
    default public void playSound(Sound sound, double x, double y, double z) {
        this.sendGroupedPacket(AdventurePacketConvertor.createSoundPacket(sound, x, y, z));
    }

    @Override
    default public void playSound(Sound sound, Sound.Emitter emitter) {
        if (emitter != Sound.Emitter.self()) {
            this.sendGroupedPacket(AdventurePacketConvertor.createSoundPacket(sound, emitter));
        } else {
            for (Audience audience : this.audiences()) {
                audience.playSound(sound, emitter);
            }
        }
    }

    @Override
    default public void stopSound(SoundStop stop) {
        this.sendGroupedPacket(AdventurePacketConvertor.createSoundStopPacket(stop));
    }

    default public void sendNotification(Notification notification) {
        this.sendGroupedPacket(notification.buildAddPacket());
        this.sendGroupedPacket(notification.buildRemovePacket());
    }

    @Override
    default public Iterable<? extends Audience> audiences() {
        return this.getPlayers();
    }
}

