/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface Result<T> {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(pure=true)
    default public <S> Result<S> map(Function<T, Result<S>> mapper) {
        Result<S> result;
        Result result2 = this;
        if (!(result2 instanceof Ok)) {
            result = this.cast();
            return result;
        }
        Ok ok = (Ok)result2;
        try {
            Object t;
            Object value = t = ok.value();
            result = mapper.apply(value);
            return result;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(pure=true)
    default public <S> Result<S> mapResult(Function<T, S> mapper) {
        Record record;
        Result result = this;
        if (!(result instanceof Ok)) {
            record = this.cast();
            return record;
        }
        Ok ok = (Ok)result;
        try {
            Object t;
            Object value = t = ok.value();
            record = new Ok<S>(mapper.apply(value));
            return record;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(pure=true)
    default public Result<T> mapError(Function<String, String> mapper) {
        Result result;
        Result result2 = this;
        if (!(result2 instanceof Error)) {
            result = this;
            return result;
        }
        Error error = (Error)result2;
        try {
            String string;
            String message = string = error.message();
            result = new Error(mapper.apply(message));
            return result;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(pure=true)
    default public @UnknownNullability T orElse(@UnknownNullability T other) {
        T t;
        Result result = this;
        if (!(result instanceof Ok)) {
            t = other;
            return t;
        }
        Ok ok = (Ok)result;
        try {
            Object t2;
            Object value = t2 = ok.value();
            t = value;
            return t;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(pure=true)
    default public T orElseThrow() {
        String errorMessage;
        Result result = this;
        Objects.requireNonNull(result);
        Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ok.class, Error.class}, (Result)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Ok ok = (Ok)result2;
                try {
                    Object t;
                    Object value = t = ok.value();
                    return value;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        Error error = (Error)result2;
        {
            String string;
            errorMessage = string = error.message();
        }
        throw new IllegalArgumentException(errorMessage);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Contract(pure=true)
    default public T orElseThrow(String message) {
        String errorMessage;
        Result result = this;
        Objects.requireNonNull(result);
        Result result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Ok.class, Error.class}, (Result)result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Ok ok = (Ok)result2;
                try {
                    Object t;
                    Object value = t = ok.value();
                    return value;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: 
        }
        Error error = (Error)result2;
        {
            String string;
            errorMessage = string = error.message();
        }
        throw new IllegalArgumentException(String.format("%s: %s", message, errorMessage));
    }

    @Contract(pure=true)
    default public <S> Error<S> cast() {
        if (!(this instanceof Error)) {
            throw new ClassCastException("Cannot cast a Result.Ok to a Result.Error");
        }
        return (Error)this;
    }

    public record Ok<T>(T value) implements Result<T>
    {
    }

    public record Error<T>(String message) implements Result<T>
    {
        public Error {
            Objects.requireNonNull(message, "Message cannot be null");
        }
    }
}

