/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.CodecImpl;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public interface StructCodec<R>
extends Codec<R> {
    public static final String INLINE = "$$inline$$";

    public <D> Result<R> decodeFromMap(Transcoder<D> var1, Transcoder.MapLike<D> var2);

    public <D> Result<D> encodeToMap(Transcoder<D> var1, R var2, Transcoder.MapBuilder<D> var3);

    @Override
    default public <D> Result<R> decode(Transcoder<D> coder, D value) {
        Objects.requireNonNull(value, "Value cannot be null");
        return coder.getMap(value).map(map -> this.decodeFromMap(coder, (Transcoder.MapLike)map));
    }

    @Override
    default public <D> Result<D> encode(Transcoder<D> coder, @Nullable R value) {
        if (value == null) {
            return new Result.Error("null");
        }
        return this.encodeToMap(coder, value, coder.createMap());
    }

    default public StructCodec<R> orElseStruct(final StructCodec<R> other) {
        return new StructCodec<R>(this){
            final /* synthetic */ StructCodec this$0;
            {
                StructCodec structCodec2 = this$0;
                Objects.requireNonNull(structCodec2);
                this.this$0 = structCodec2;
            }

            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Result primaryResult = this.this$0.decodeFromMap(coder, map);
                if (primaryResult instanceof Result.Ok) {
                    Result.Ok primaryOk = (Result.Ok)primaryResult;
                    return primaryOk;
                }
                Result secondaryResult = other.decodeFromMap(coder, map);
                if (secondaryResult instanceof Result.Ok) {
                    Result.Ok secondaryOk = (Result.Ok)secondaryResult;
                    return secondaryOk;
                }
                return primaryResult;
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                return this.this$0.encodeToMap(coder, value, map);
            }
        };
    }

    public static <R> StructCodec<R> struct(R value) {
        final Result.Ok<R> ok = new Result.Ok<R>(Objects.requireNonNull(value, "value"));
        return new StructCodec<R>(){

            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                return ok;
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R> StructCodec<R> struct(final Supplier<R> ctor) {
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                return new Result.Ok(ctor.get());
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final NetworkBufferTemplate.F1<P1, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t;
                    value1 = t = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                return new Result.Ok(ctor.apply(value1));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final NetworkBufferTemplate.F2<P1, P2, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final NetworkBufferTemplate.F3<P1, P2, P3, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final NetworkBufferTemplate.F4<P1, P2, P3, P4, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final NetworkBufferTemplate.F5<P1, P2, P3, P4, P5, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final NetworkBufferTemplate.F6<P1, P2, P3, P4, P5, P6, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final NetworkBufferTemplate.F7<P1, P2, P3, P4, P5, P6, P7, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final NetworkBufferTemplate.F8<P1, P2, P3, P4, P5, P6, P7, P8, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final NetworkBufferTemplate.F9<P1, P2, P3, P4, P5, P6, P7, P8, P9, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final NetworkBufferTemplate.F10<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final NetworkBufferTemplate.F11<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final NetworkBufferTemplate.F12<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final String name13, final Codec<P13> codec13, final Function<R, P13> getter13, final NetworkBufferTemplate.F13<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(name13, "name13");
        Objects.requireNonNull(codec13, "codec13");
        Objects.requireNonNull(getter13, "getter13");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                Result result13 = StructCodec.get(coder, codec13, name13, map);
                if (!(result13 instanceof Result.Ok)) return result13.cast();
                ok = (Result.Ok)result13;
                Object value13 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12, value13));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                Result<D> result13 = StructCodec.put(coder, codec13, map, name13, getter13.apply(value));
                if (result13 != null) {
                    return result13;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final String name13, final Codec<P13> codec13, final Function<R, P13> getter13, final String name14, final Codec<P14> codec14, final Function<R, P14> getter14, final NetworkBufferTemplate.F14<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(name13, "name13");
        Objects.requireNonNull(codec13, "codec13");
        Objects.requireNonNull(getter13, "getter13");
        Objects.requireNonNull(name14, "name14");
        Objects.requireNonNull(codec14, "codec14");
        Objects.requireNonNull(getter14, "getter14");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                Result result13 = StructCodec.get(coder, codec13, name13, map);
                if (!(result13 instanceof Result.Ok)) return result13.cast();
                ok = (Result.Ok)result13;
                Object value13 = t = ok.value();
                Result result14 = StructCodec.get(coder, codec14, name14, map);
                if (!(result14 instanceof Result.Ok)) return result14.cast();
                ok = (Result.Ok)result14;
                Object value14 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12, value13, value14));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                Result<D> result13 = StructCodec.put(coder, codec13, map, name13, getter13.apply(value));
                if (result13 != null) {
                    return result13;
                }
                Result<D> result14 = StructCodec.put(coder, codec14, map, name14, getter14.apply(value));
                if (result14 != null) {
                    return result14;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final String name13, final Codec<P13> codec13, final Function<R, P13> getter13, final String name14, final Codec<P14> codec14, final Function<R, P14> getter14, final String name15, final Codec<P15> codec15, final Function<R, P15> getter15, final NetworkBufferTemplate.F15<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(name13, "name13");
        Objects.requireNonNull(codec13, "codec13");
        Objects.requireNonNull(getter13, "getter13");
        Objects.requireNonNull(name14, "name14");
        Objects.requireNonNull(codec14, "codec14");
        Objects.requireNonNull(getter14, "getter14");
        Objects.requireNonNull(name15, "name15");
        Objects.requireNonNull(codec15, "codec15");
        Objects.requireNonNull(getter15, "getter15");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                Result result13 = StructCodec.get(coder, codec13, name13, map);
                if (!(result13 instanceof Result.Ok)) return result13.cast();
                ok = (Result.Ok)result13;
                Object value13 = t = ok.value();
                Result result14 = StructCodec.get(coder, codec14, name14, map);
                if (!(result14 instanceof Result.Ok)) return result14.cast();
                ok = (Result.Ok)result14;
                Object value14 = t = ok.value();
                Result result15 = StructCodec.get(coder, codec15, name15, map);
                if (!(result15 instanceof Result.Ok)) return result15.cast();
                ok = (Result.Ok)result15;
                Object value15 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12, value13, value14, value15));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                Result<D> result13 = StructCodec.put(coder, codec13, map, name13, getter13.apply(value));
                if (result13 != null) {
                    return result13;
                }
                Result<D> result14 = StructCodec.put(coder, codec14, map, name14, getter14.apply(value));
                if (result14 != null) {
                    return result14;
                }
                Result<D> result15 = StructCodec.put(coder, codec15, map, name15, getter15.apply(value));
                if (result15 != null) {
                    return result15;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final String name13, final Codec<P13> codec13, final Function<R, P13> getter13, final String name14, final Codec<P14> codec14, final Function<R, P14> getter14, final String name15, final Codec<P15> codec15, final Function<R, P15> getter15, final String name16, final Codec<P16> codec16, final Function<R, P16> getter16, final NetworkBufferTemplate.F16<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(name13, "name13");
        Objects.requireNonNull(codec13, "codec13");
        Objects.requireNonNull(getter13, "getter13");
        Objects.requireNonNull(name14, "name14");
        Objects.requireNonNull(codec14, "codec14");
        Objects.requireNonNull(getter14, "getter14");
        Objects.requireNonNull(name15, "name15");
        Objects.requireNonNull(codec15, "codec15");
        Objects.requireNonNull(getter15, "getter15");
        Objects.requireNonNull(name16, "name16");
        Objects.requireNonNull(codec16, "codec16");
        Objects.requireNonNull(getter16, "getter16");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                Result result13 = StructCodec.get(coder, codec13, name13, map);
                if (!(result13 instanceof Result.Ok)) return result13.cast();
                ok = (Result.Ok)result13;
                Object value13 = t = ok.value();
                Result result14 = StructCodec.get(coder, codec14, name14, map);
                if (!(result14 instanceof Result.Ok)) return result14.cast();
                ok = (Result.Ok)result14;
                Object value14 = t = ok.value();
                Result result15 = StructCodec.get(coder, codec15, name15, map);
                if (!(result15 instanceof Result.Ok)) return result15.cast();
                ok = (Result.Ok)result15;
                Object value15 = t = ok.value();
                Result result16 = StructCodec.get(coder, codec16, name16, map);
                if (!(result16 instanceof Result.Ok)) return result16.cast();
                ok = (Result.Ok)result16;
                Object value16 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12, value13, value14, value15, value16));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                Result<D> result13 = StructCodec.put(coder, codec13, map, name13, getter13.apply(value));
                if (result13 != null) {
                    return result13;
                }
                Result<D> result14 = StructCodec.put(coder, codec14, map, name14, getter14.apply(value));
                if (result14 != null) {
                    return result14;
                }
                Result<D> result15 = StructCodec.put(coder, codec15, map, name15, getter15.apply(value));
                if (result15 != null) {
                    return result15;
                }
                Result<D> result16 = StructCodec.put(coder, codec16, map, name16, getter16.apply(value));
                if (result16 != null) {
                    return result16;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final String name13, final Codec<P13> codec13, final Function<R, P13> getter13, final String name14, final Codec<P14> codec14, final Function<R, P14> getter14, final String name15, final Codec<P15> codec15, final Function<R, P15> getter15, final String name16, final Codec<P16> codec16, final Function<R, P16> getter16, final String name17, final Codec<P17> codec17, final Function<R, P17> getter17, final NetworkBufferTemplate.F17<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(name13, "name13");
        Objects.requireNonNull(codec13, "codec13");
        Objects.requireNonNull(getter13, "getter13");
        Objects.requireNonNull(name14, "name14");
        Objects.requireNonNull(codec14, "codec14");
        Objects.requireNonNull(getter14, "getter14");
        Objects.requireNonNull(name15, "name15");
        Objects.requireNonNull(codec15, "codec15");
        Objects.requireNonNull(getter15, "getter15");
        Objects.requireNonNull(name16, "name16");
        Objects.requireNonNull(codec16, "codec16");
        Objects.requireNonNull(getter16, "getter16");
        Objects.requireNonNull(name17, "name17");
        Objects.requireNonNull(codec17, "codec17");
        Objects.requireNonNull(getter17, "getter17");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                Result result13 = StructCodec.get(coder, codec13, name13, map);
                if (!(result13 instanceof Result.Ok)) return result13.cast();
                ok = (Result.Ok)result13;
                Object value13 = t = ok.value();
                Result result14 = StructCodec.get(coder, codec14, name14, map);
                if (!(result14 instanceof Result.Ok)) return result14.cast();
                ok = (Result.Ok)result14;
                Object value14 = t = ok.value();
                Result result15 = StructCodec.get(coder, codec15, name15, map);
                if (!(result15 instanceof Result.Ok)) return result15.cast();
                ok = (Result.Ok)result15;
                Object value15 = t = ok.value();
                Result result16 = StructCodec.get(coder, codec16, name16, map);
                if (!(result16 instanceof Result.Ok)) return result16.cast();
                ok = (Result.Ok)result16;
                Object value16 = t = ok.value();
                Result result17 = StructCodec.get(coder, codec17, name17, map);
                if (!(result17 instanceof Result.Ok)) return result17.cast();
                ok = (Result.Ok)result17;
                Object value17 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12, value13, value14, value15, value16, value17));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                Result<D> result13 = StructCodec.put(coder, codec13, map, name13, getter13.apply(value));
                if (result13 != null) {
                    return result13;
                }
                Result<D> result14 = StructCodec.put(coder, codec14, map, name14, getter14.apply(value));
                if (result14 != null) {
                    return result14;
                }
                Result<D> result15 = StructCodec.put(coder, codec15, map, name15, getter15.apply(value));
                if (result15 != null) {
                    return result15;
                }
                Result<D> result16 = StructCodec.put(coder, codec16, map, name16, getter16.apply(value));
                if (result16 != null) {
                    return result16;
                }
                Result<D> result17 = StructCodec.put(coder, codec17, map, name17, getter17.apply(value));
                if (result17 != null) {
                    return result17;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final String name13, final Codec<P13> codec13, final Function<R, P13> getter13, final String name14, final Codec<P14> codec14, final Function<R, P14> getter14, final String name15, final Codec<P15> codec15, final Function<R, P15> getter15, final String name16, final Codec<P16> codec16, final Function<R, P16> getter16, final String name17, final Codec<P17> codec17, final Function<R, P17> getter17, final String name18, final Codec<P18> codec18, final Function<R, P18> getter18, final NetworkBufferTemplate.F18<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(name13, "name13");
        Objects.requireNonNull(codec13, "codec13");
        Objects.requireNonNull(getter13, "getter13");
        Objects.requireNonNull(name14, "name14");
        Objects.requireNonNull(codec14, "codec14");
        Objects.requireNonNull(getter14, "getter14");
        Objects.requireNonNull(name15, "name15");
        Objects.requireNonNull(codec15, "codec15");
        Objects.requireNonNull(getter15, "getter15");
        Objects.requireNonNull(name16, "name16");
        Objects.requireNonNull(codec16, "codec16");
        Objects.requireNonNull(getter16, "getter16");
        Objects.requireNonNull(name17, "name17");
        Objects.requireNonNull(codec17, "codec17");
        Objects.requireNonNull(getter17, "getter17");
        Objects.requireNonNull(name18, "name18");
        Objects.requireNonNull(codec18, "codec18");
        Objects.requireNonNull(getter18, "getter18");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                Result result13 = StructCodec.get(coder, codec13, name13, map);
                if (!(result13 instanceof Result.Ok)) return result13.cast();
                ok = (Result.Ok)result13;
                Object value13 = t = ok.value();
                Result result14 = StructCodec.get(coder, codec14, name14, map);
                if (!(result14 instanceof Result.Ok)) return result14.cast();
                ok = (Result.Ok)result14;
                Object value14 = t = ok.value();
                Result result15 = StructCodec.get(coder, codec15, name15, map);
                if (!(result15 instanceof Result.Ok)) return result15.cast();
                ok = (Result.Ok)result15;
                Object value15 = t = ok.value();
                Result result16 = StructCodec.get(coder, codec16, name16, map);
                if (!(result16 instanceof Result.Ok)) return result16.cast();
                ok = (Result.Ok)result16;
                Object value16 = t = ok.value();
                Result result17 = StructCodec.get(coder, codec17, name17, map);
                if (!(result17 instanceof Result.Ok)) return result17.cast();
                ok = (Result.Ok)result17;
                Object value17 = t = ok.value();
                Result result18 = StructCodec.get(coder, codec18, name18, map);
                if (!(result18 instanceof Result.Ok)) return result18.cast();
                ok = (Result.Ok)result18;
                Object value18 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12, value13, value14, value15, value16, value17, value18));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                Result<D> result13 = StructCodec.put(coder, codec13, map, name13, getter13.apply(value));
                if (result13 != null) {
                    return result13;
                }
                Result<D> result14 = StructCodec.put(coder, codec14, map, name14, getter14.apply(value));
                if (result14 != null) {
                    return result14;
                }
                Result<D> result15 = StructCodec.put(coder, codec15, map, name15, getter15.apply(value));
                if (result15 != null) {
                    return result15;
                }
                Result<D> result16 = StructCodec.put(coder, codec16, map, name16, getter16.apply(value));
                if (result16 != null) {
                    return result16;
                }
                Result<D> result17 = StructCodec.put(coder, codec17, map, name17, getter17.apply(value));
                if (result17 != null) {
                    return result17;
                }
                Result<D> result18 = StructCodec.put(coder, codec18, map, name18, getter18.apply(value));
                if (result18 != null) {
                    return result18;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final String name13, final Codec<P13> codec13, final Function<R, P13> getter13, final String name14, final Codec<P14> codec14, final Function<R, P14> getter14, final String name15, final Codec<P15> codec15, final Function<R, P15> getter15, final String name16, final Codec<P16> codec16, final Function<R, P16> getter16, final String name17, final Codec<P17> codec17, final Function<R, P17> getter17, final String name18, final Codec<P18> codec18, final Function<R, P18> getter18, final String name19, final Codec<P19> codec19, final Function<R, P19> getter19, final NetworkBufferTemplate.F19<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(name13, "name13");
        Objects.requireNonNull(codec13, "codec13");
        Objects.requireNonNull(getter13, "getter13");
        Objects.requireNonNull(name14, "name14");
        Objects.requireNonNull(codec14, "codec14");
        Objects.requireNonNull(getter14, "getter14");
        Objects.requireNonNull(name15, "name15");
        Objects.requireNonNull(codec15, "codec15");
        Objects.requireNonNull(getter15, "getter15");
        Objects.requireNonNull(name16, "name16");
        Objects.requireNonNull(codec16, "codec16");
        Objects.requireNonNull(getter16, "getter16");
        Objects.requireNonNull(name17, "name17");
        Objects.requireNonNull(codec17, "codec17");
        Objects.requireNonNull(getter17, "getter17");
        Objects.requireNonNull(name18, "name18");
        Objects.requireNonNull(codec18, "codec18");
        Objects.requireNonNull(getter18, "getter18");
        Objects.requireNonNull(name19, "name19");
        Objects.requireNonNull(codec19, "codec19");
        Objects.requireNonNull(getter19, "getter19");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                Result result13 = StructCodec.get(coder, codec13, name13, map);
                if (!(result13 instanceof Result.Ok)) return result13.cast();
                ok = (Result.Ok)result13;
                Object value13 = t = ok.value();
                Result result14 = StructCodec.get(coder, codec14, name14, map);
                if (!(result14 instanceof Result.Ok)) return result14.cast();
                ok = (Result.Ok)result14;
                Object value14 = t = ok.value();
                Result result15 = StructCodec.get(coder, codec15, name15, map);
                if (!(result15 instanceof Result.Ok)) return result15.cast();
                ok = (Result.Ok)result15;
                Object value15 = t = ok.value();
                Result result16 = StructCodec.get(coder, codec16, name16, map);
                if (!(result16 instanceof Result.Ok)) return result16.cast();
                ok = (Result.Ok)result16;
                Object value16 = t = ok.value();
                Result result17 = StructCodec.get(coder, codec17, name17, map);
                if (!(result17 instanceof Result.Ok)) return result17.cast();
                ok = (Result.Ok)result17;
                Object value17 = t = ok.value();
                Result result18 = StructCodec.get(coder, codec18, name18, map);
                if (!(result18 instanceof Result.Ok)) return result18.cast();
                ok = (Result.Ok)result18;
                Object value18 = t = ok.value();
                Result result19 = StructCodec.get(coder, codec19, name19, map);
                if (!(result19 instanceof Result.Ok)) return result19.cast();
                ok = (Result.Ok)result19;
                Object value19 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12, value13, value14, value15, value16, value17, value18, value19));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                Result<D> result13 = StructCodec.put(coder, codec13, map, name13, getter13.apply(value));
                if (result13 != null) {
                    return result13;
                }
                Result<D> result14 = StructCodec.put(coder, codec14, map, name14, getter14.apply(value));
                if (result14 != null) {
                    return result14;
                }
                Result<D> result15 = StructCodec.put(coder, codec15, map, name15, getter15.apply(value));
                if (result15 != null) {
                    return result15;
                }
                Result<D> result16 = StructCodec.put(coder, codec16, map, name16, getter16.apply(value));
                if (result16 != null) {
                    return result16;
                }
                Result<D> result17 = StructCodec.put(coder, codec17, map, name17, getter17.apply(value));
                if (result17 != null) {
                    return result17;
                }
                Result<D> result18 = StructCodec.put(coder, codec18, map, name18, getter18.apply(value));
                if (result18 != null) {
                    return result18;
                }
                Result<D> result19 = StructCodec.put(coder, codec19, map, name19, getter19.apply(value));
                if (result19 != null) {
                    return result19;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    public static <R, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, P20> StructCodec<R> struct(final String name1, final Codec<P1> codec1, final Function<R, P1> getter1, final String name2, final Codec<P2> codec2, final Function<R, P2> getter2, final String name3, final Codec<P3> codec3, final Function<R, P3> getter3, final String name4, final Codec<P4> codec4, final Function<R, P4> getter4, final String name5, final Codec<P5> codec5, final Function<R, P5> getter5, final String name6, final Codec<P6> codec6, final Function<R, P6> getter6, final String name7, final Codec<P7> codec7, final Function<R, P7> getter7, final String name8, final Codec<P8> codec8, final Function<R, P8> getter8, final String name9, final Codec<P9> codec9, final Function<R, P9> getter9, final String name10, final Codec<P10> codec10, final Function<R, P10> getter10, final String name11, final Codec<P11> codec11, final Function<R, P11> getter11, final String name12, final Codec<P12> codec12, final Function<R, P12> getter12, final String name13, final Codec<P13> codec13, final Function<R, P13> getter13, final String name14, final Codec<P14> codec14, final Function<R, P14> getter14, final String name15, final Codec<P15> codec15, final Function<R, P15> getter15, final String name16, final Codec<P16> codec16, final Function<R, P16> getter16, final String name17, final Codec<P17> codec17, final Function<R, P17> getter17, final String name18, final Codec<P18> codec18, final Function<R, P18> getter18, final String name19, final Codec<P19> codec19, final Function<R, P19> getter19, final String name20, final Codec<P20> codec20, final Function<R, P20> getter20, final NetworkBufferTemplate.F20<P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14, P15, P16, P17, P18, P19, P20, R> ctor) {
        Objects.requireNonNull(name1, "name1");
        Objects.requireNonNull(codec1, "codec1");
        Objects.requireNonNull(getter1, "getter1");
        Objects.requireNonNull(name2, "name2");
        Objects.requireNonNull(codec2, "codec2");
        Objects.requireNonNull(getter2, "getter2");
        Objects.requireNonNull(name3, "name3");
        Objects.requireNonNull(codec3, "codec3");
        Objects.requireNonNull(getter3, "getter3");
        Objects.requireNonNull(name4, "name4");
        Objects.requireNonNull(codec4, "codec4");
        Objects.requireNonNull(getter4, "getter4");
        Objects.requireNonNull(name5, "name5");
        Objects.requireNonNull(codec5, "codec5");
        Objects.requireNonNull(getter5, "getter5");
        Objects.requireNonNull(name6, "name6");
        Objects.requireNonNull(codec6, "codec6");
        Objects.requireNonNull(getter6, "getter6");
        Objects.requireNonNull(name7, "name7");
        Objects.requireNonNull(codec7, "codec7");
        Objects.requireNonNull(getter7, "getter7");
        Objects.requireNonNull(name8, "name8");
        Objects.requireNonNull(codec8, "codec8");
        Objects.requireNonNull(getter8, "getter8");
        Objects.requireNonNull(name9, "name9");
        Objects.requireNonNull(codec9, "codec9");
        Objects.requireNonNull(getter9, "getter9");
        Objects.requireNonNull(name10, "name10");
        Objects.requireNonNull(codec10, "codec10");
        Objects.requireNonNull(getter10, "getter10");
        Objects.requireNonNull(name11, "name11");
        Objects.requireNonNull(codec11, "codec11");
        Objects.requireNonNull(getter11, "getter11");
        Objects.requireNonNull(name12, "name12");
        Objects.requireNonNull(codec12, "codec12");
        Objects.requireNonNull(getter12, "getter12");
        Objects.requireNonNull(name13, "name13");
        Objects.requireNonNull(codec13, "codec13");
        Objects.requireNonNull(getter13, "getter13");
        Objects.requireNonNull(name14, "name14");
        Objects.requireNonNull(codec14, "codec14");
        Objects.requireNonNull(getter14, "getter14");
        Objects.requireNonNull(name15, "name15");
        Objects.requireNonNull(codec15, "codec15");
        Objects.requireNonNull(getter15, "getter15");
        Objects.requireNonNull(name16, "name16");
        Objects.requireNonNull(codec16, "codec16");
        Objects.requireNonNull(getter16, "getter16");
        Objects.requireNonNull(name17, "name17");
        Objects.requireNonNull(codec17, "codec17");
        Objects.requireNonNull(getter17, "getter17");
        Objects.requireNonNull(name18, "name18");
        Objects.requireNonNull(codec18, "codec18");
        Objects.requireNonNull(getter18, "getter18");
        Objects.requireNonNull(name19, "name19");
        Objects.requireNonNull(codec19, "codec19");
        Objects.requireNonNull(getter19, "getter19");
        Objects.requireNonNull(name20, "name20");
        Objects.requireNonNull(codec20, "codec20");
        Objects.requireNonNull(getter20, "getter20");
        Objects.requireNonNull(ctor, "ctor");
        return new StructCodec<R>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<R> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
                Object t;
                Object value1;
                Result result1 = StructCodec.get(coder, codec1, name1, map);
                if (!(result1 instanceof Result.Ok)) return result1.cast();
                Result.Ok ok = (Result.Ok)result1;
                try {
                    Object t2;
                    value1 = t2 = ok.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Result result2 = StructCodec.get(coder, codec2, name2, map);
                if (!(result2 instanceof Result.Ok)) return result2.cast();
                ok = (Result.Ok)result2;
                Object value2 = t = ok.value();
                Result result3 = StructCodec.get(coder, codec3, name3, map);
                if (!(result3 instanceof Result.Ok)) return result3.cast();
                ok = (Result.Ok)result3;
                Object value3 = t = ok.value();
                Result result4 = StructCodec.get(coder, codec4, name4, map);
                if (!(result4 instanceof Result.Ok)) return result4.cast();
                ok = (Result.Ok)result4;
                Object value4 = t = ok.value();
                Result result5 = StructCodec.get(coder, codec5, name5, map);
                if (!(result5 instanceof Result.Ok)) return result5.cast();
                ok = (Result.Ok)result5;
                Object value5 = t = ok.value();
                Result result6 = StructCodec.get(coder, codec6, name6, map);
                if (!(result6 instanceof Result.Ok)) return result6.cast();
                ok = (Result.Ok)result6;
                Object value6 = t = ok.value();
                Result result7 = StructCodec.get(coder, codec7, name7, map);
                if (!(result7 instanceof Result.Ok)) return result7.cast();
                ok = (Result.Ok)result7;
                Object value7 = t = ok.value();
                Result result8 = StructCodec.get(coder, codec8, name8, map);
                if (!(result8 instanceof Result.Ok)) return result8.cast();
                ok = (Result.Ok)result8;
                Object value8 = t = ok.value();
                Result result9 = StructCodec.get(coder, codec9, name9, map);
                if (!(result9 instanceof Result.Ok)) return result9.cast();
                ok = (Result.Ok)result9;
                Object value9 = t = ok.value();
                Result result10 = StructCodec.get(coder, codec10, name10, map);
                if (!(result10 instanceof Result.Ok)) return result10.cast();
                ok = (Result.Ok)result10;
                Object value10 = t = ok.value();
                Result result11 = StructCodec.get(coder, codec11, name11, map);
                if (!(result11 instanceof Result.Ok)) return result11.cast();
                ok = (Result.Ok)result11;
                Object value11 = t = ok.value();
                Result result12 = StructCodec.get(coder, codec12, name12, map);
                if (!(result12 instanceof Result.Ok)) return result12.cast();
                ok = (Result.Ok)result12;
                Object value12 = t = ok.value();
                Result result13 = StructCodec.get(coder, codec13, name13, map);
                if (!(result13 instanceof Result.Ok)) return result13.cast();
                ok = (Result.Ok)result13;
                Object value13 = t = ok.value();
                Result result14 = StructCodec.get(coder, codec14, name14, map);
                if (!(result14 instanceof Result.Ok)) return result14.cast();
                ok = (Result.Ok)result14;
                Object value14 = t = ok.value();
                Result result15 = StructCodec.get(coder, codec15, name15, map);
                if (!(result15 instanceof Result.Ok)) return result15.cast();
                ok = (Result.Ok)result15;
                Object value15 = t = ok.value();
                Result result16 = StructCodec.get(coder, codec16, name16, map);
                if (!(result16 instanceof Result.Ok)) return result16.cast();
                ok = (Result.Ok)result16;
                Object value16 = t = ok.value();
                Result result17 = StructCodec.get(coder, codec17, name17, map);
                if (!(result17 instanceof Result.Ok)) return result17.cast();
                ok = (Result.Ok)result17;
                Object value17 = t = ok.value();
                Result result18 = StructCodec.get(coder, codec18, name18, map);
                if (!(result18 instanceof Result.Ok)) return result18.cast();
                ok = (Result.Ok)result18;
                Object value18 = t = ok.value();
                Result result19 = StructCodec.get(coder, codec19, name19, map);
                if (!(result19 instanceof Result.Ok)) return result19.cast();
                ok = (Result.Ok)result19;
                Object value19 = t = ok.value();
                Result result20 = StructCodec.get(coder, codec20, name20, map);
                if (!(result20 instanceof Result.Ok)) return result20.cast();
                ok = (Result.Ok)result20;
                Object value20 = t = ok.value();
                return new Result.Ok(ctor.apply(value1, value2, value3, value4, value5, value6, value7, value8, value9, value10, value11, value12, value13, value14, value15, value16, value17, value18, value19, value20));
            }

            @Override
            public <D> Result<D> encodeToMap(Transcoder<D> coder, R value, Transcoder.MapBuilder<D> map) {
                Result<D> result1 = StructCodec.put(coder, codec1, map, name1, getter1.apply(value));
                if (result1 != null) {
                    return result1;
                }
                Result<D> result2 = StructCodec.put(coder, codec2, map, name2, getter2.apply(value));
                if (result2 != null) {
                    return result2;
                }
                Result<D> result3 = StructCodec.put(coder, codec3, map, name3, getter3.apply(value));
                if (result3 != null) {
                    return result3;
                }
                Result<D> result4 = StructCodec.put(coder, codec4, map, name4, getter4.apply(value));
                if (result4 != null) {
                    return result4;
                }
                Result<D> result5 = StructCodec.put(coder, codec5, map, name5, getter5.apply(value));
                if (result5 != null) {
                    return result5;
                }
                Result<D> result6 = StructCodec.put(coder, codec6, map, name6, getter6.apply(value));
                if (result6 != null) {
                    return result6;
                }
                Result<D> result7 = StructCodec.put(coder, codec7, map, name7, getter7.apply(value));
                if (result7 != null) {
                    return result7;
                }
                Result<D> result8 = StructCodec.put(coder, codec8, map, name8, getter8.apply(value));
                if (result8 != null) {
                    return result8;
                }
                Result<D> result9 = StructCodec.put(coder, codec9, map, name9, getter9.apply(value));
                if (result9 != null) {
                    return result9;
                }
                Result<D> result10 = StructCodec.put(coder, codec10, map, name10, getter10.apply(value));
                if (result10 != null) {
                    return result10;
                }
                Result<D> result11 = StructCodec.put(coder, codec11, map, name11, getter11.apply(value));
                if (result11 != null) {
                    return result11;
                }
                Result<D> result12 = StructCodec.put(coder, codec12, map, name12, getter12.apply(value));
                if (result12 != null) {
                    return result12;
                }
                Result<D> result13 = StructCodec.put(coder, codec13, map, name13, getter13.apply(value));
                if (result13 != null) {
                    return result13;
                }
                Result<D> result14 = StructCodec.put(coder, codec14, map, name14, getter14.apply(value));
                if (result14 != null) {
                    return result14;
                }
                Result<D> result15 = StructCodec.put(coder, codec15, map, name15, getter15.apply(value));
                if (result15 != null) {
                    return result15;
                }
                Result<D> result16 = StructCodec.put(coder, codec16, map, name16, getter16.apply(value));
                if (result16 != null) {
                    return result16;
                }
                Result<D> result17 = StructCodec.put(coder, codec17, map, name17, getter17.apply(value));
                if (result17 != null) {
                    return result17;
                }
                Result<D> result18 = StructCodec.put(coder, codec18, map, name18, getter18.apply(value));
                if (result18 != null) {
                    return result18;
                }
                Result<D> result19 = StructCodec.put(coder, codec19, map, name19, getter19.apply(value));
                if (result19 != null) {
                    return result19;
                }
                Result<D> result20 = StructCodec.put(coder, codec20, map, name20, getter20.apply(value));
                if (result20 != null) {
                    return result20;
                }
                return new Result.Ok<D>(map.build());
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <D, T> Result<@UnknownNullability T> get(Transcoder<D> coder, Codec<T> codec, String key, Transcoder.MapLike<D> map) {
        Result result;
        Codec inner;
        Object object;
        if (INLINE.equals(key)) {
            Codec codec3;
            Codec decodeCodec;
            CodecImpl.OptionalImpl optionalImpl;
            if (codec instanceof CodecImpl.OptionalImpl) {
                Codec codec2;
                optionalImpl = (CodecImpl.OptionalImpl)codec;
                Codec inner2 = codec2 = optionalImpl.inner();
                Codec ignored = codec2 = optionalImpl.defaultValue();
                v0 = inner2;
            } else {
                v0 = decodeCodec = codec;
            }
            if (!(decodeCodec instanceof StructCodec)) {
                return new Result.Error(key + ": not a struct");
            }
            StructCodec s = (StructCodec)decodeCodec;
            Result decodeResult = s.decodeFromMap(coder, map);
            if (!(decodeResult instanceof Result.Error) || !(codec instanceof CodecImpl.OptionalImpl)) return decodeResult.mapError(e -> key + ": " + e);
            optionalImpl = (CodecImpl.OptionalImpl)codec;
            Codec ignored = codec3 = optionalImpl.inner();
            Codec defaultValue = codec3 = optionalImpl.defaultValue();
            return new Result.Ok(defaultValue);
        }
        if (!(codec instanceof CodecImpl.OptionalImpl)) return map.getValue(key).map(innerValue -> codec.decode(coder, innerValue)).mapError(e -> key + ": " + e);
        CodecImpl.OptionalImpl optionalImpl = (CodecImpl.OptionalImpl)codec;
        try {
            object = optionalImpl.inner();
            inner = object;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        object = optionalImpl.defaultValue();
        Codec defaultValue = object;
        Result<D> result2 = map.getValue(key);
        Objects.requireNonNull(result2);
        object = result2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, (Result)object, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Object t;
                Result.Ok ok = (Result.Ok)object;
                Object innerValue2 = t = ok.value();
                result = inner.decode(coder, innerValue2).mapError(e -> key + ": " + e);
                return result;
            }
            case 1: {
                String string;
                Result.Error error = (Result.Error)object;
                String ignored = string = error.message();
                result = new Result.Ok(defaultValue);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static <D, T> Result<D> put(Transcoder<D> coder, Codec<T> codec, Transcoder.MapBuilder<D> map, String key, @Nullable T value) {
        Result.Error error;
        if (value == null) {
            if (codec instanceof CodecImpl.OptionalImpl) return null;
            return new Result.Error(key + ": null");
        }
        if (INLINE.equals(key)) {
            Codec<T> codec2;
            if (codec instanceof CodecImpl.OptionalImpl) {
                CodecImpl.OptionalImpl optionalImpl = (CodecImpl.OptionalImpl)codec;
                try {
                    Object t;
                    Codec codec3;
                    Codec inner = codec3 = optionalImpl.inner();
                    Object t2 = t = optionalImpl.defaultValue();
                    codec2 = inner;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            } else {
                codec2 = codec;
            }
            Codec<T> encodeCodec = codec2;
            if (!(encodeCodec instanceof StructCodec)) return new Result.Error(key + ": not a struct");
            StructCodec structCodec = (StructCodec)encodeCodec;
            Result<D> mapEncodeResult = structCodec.encodeToMap(coder, value, map);
            if (!(mapEncodeResult instanceof Result.Error)) return null;
            Result.Error e = (Result.Error)mapEncodeResult;
            return new Result.Error(key + ": " + String.valueOf(e));
        }
        Result<D> result = codec.encode(coder, value);
        Objects.requireNonNull(result);
        Result<D> result2 = result;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Result.Ok.class, Result.Error.class}, result2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Result.Ok ok = (Result.Ok)result2;
                {
                    Object t;
                    Object ok2 = t = ok.value();
                    if (ok2 == null) return null;
                    map.put(key, ok2);
                }
                return null;
            }
            case 1: 
        }
        Result.Error error2 = (Result.Error)result2;
        {
            String string;
            String message = string = error2.message();
            error = new Result.Error(key + ": " + message);
        }
        return error;
    }
}

