/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.nbt.BinaryTag;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.TranscoderCrc32Impl;
import net.minestom.server.codec.TranscoderJavaImpl;
import net.minestom.server.codec.TranscoderJsonImpl;
import net.minestom.server.codec.TranscoderNbtImpl;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Unmodifiable;

public interface Transcoder<D> {
    public static final Transcoder<BinaryTag> NBT = TranscoderNbtImpl.INSTANCE;
    public static final Transcoder<JsonElement> JSON = TranscoderJsonImpl.INSTANCE;
    public static final Transcoder<Object> JAVA = TranscoderJavaImpl.INSTANCE;
    @ApiStatus.Experimental
    public static final Transcoder<Integer> CRC32_HASH = TranscoderCrc32Impl.INSTANCE;

    public D createNull();

    public Result<Boolean> getBoolean(D var1);

    public D createBoolean(boolean var1);

    public Result<Byte> getByte(D var1);

    public D createByte(byte var1);

    public Result<Short> getShort(D var1);

    public D createShort(short var1);

    public Result<Integer> getInt(D var1);

    public D createInt(int var1);

    public Result<Long> getLong(D var1);

    public D createLong(long var1);

    public Result<Float> getFloat(D var1);

    public D createFloat(float var1);

    public Result<Double> getDouble(D var1);

    public D createDouble(double var1);

    public Result<String> getString(D var1);

    public D createString(String var1);

    public Result<@Unmodifiable List<D>> getList(D var1);

    default public D emptyList() {
        return this.createList(0).build();
    }

    @Contract(pure=true)
    public ListBuilder<D> createList(int var1);

    public Result<MapLike<D>> getMap(D var1);

    default public D emptyMap() {
        return this.createMap().build();
    }

    @Contract(pure=true)
    public MapBuilder<D> createMap();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Result<byte[]> getByteArray(D value) {
        List list;
        Result<List<D>> listResult = this.getList(value);
        if (!(listResult instanceof Result.Ok)) return listResult.cast();
        Result.Ok ok = (Result.Ok)listResult;
        try {
            List list2;
            list = list2 = (List)ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        byte[] byteArray = new byte[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Byte by;
            Result<Byte> byteResult = this.getByte(list.get(i));
            if (!(byteResult instanceof Result.Ok)) return byteResult.cast();
            ok = (Result.Ok)byteResult;
            Byte byteValue = by = (Byte)ok.value();
            byteArray[i] = byteValue;
        }
        return new Result.Ok<byte[]>(byteArray);
    }

    default public D createByteArray(byte[] value) {
        ListBuilder<D> list = this.createList(value.length);
        for (byte b : value) {
            list.add(this.createByte(b));
        }
        return list.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Result<int[]> getIntArray(D value) {
        List list;
        Result<List<D>> listResult = this.getList(value);
        if (!(listResult instanceof Result.Ok)) return listResult.cast();
        Result.Ok ok = (Result.Ok)listResult;
        try {
            List list2;
            list = list2 = (List)ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        int[] intArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Integer n;
            Result<Integer> intResult = this.getInt(list.get(i));
            if (!(intResult instanceof Result.Ok)) return intResult.cast();
            ok = (Result.Ok)intResult;
            Integer intValue = n = (Integer)ok.value();
            intArray[i] = intValue;
        }
        return new Result.Ok<int[]>(intArray);
    }

    default public D createIntArray(int[] value) {
        ListBuilder<D> list = this.createList(value.length);
        for (int i : value) {
            list.add(this.createInt(i));
        }
        return list.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public Result<long[]> getLongArray(D value) {
        List list;
        Result<List<D>> listResult = this.getList(value);
        if (!(listResult instanceof Result.Ok)) return listResult.cast();
        Result.Ok ok = (Result.Ok)listResult;
        try {
            List list2;
            list = list2 = (List)ok.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        long[] longArray = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Long l;
            Result<Long> longResult = this.getLong(list.get(i));
            if (!(longResult instanceof Result.Ok)) return longResult.cast();
            ok = (Result.Ok)longResult;
            Long longValue = l = (Long)ok.value();
            longArray[i] = longValue;
        }
        return new Result.Ok<long[]>(longArray);
    }

    default public D createLongArray(long[] value) {
        ListBuilder<D> list = this.createList(value.length);
        for (long l : value) {
            list.add(this.createLong(l));
        }
        return list.build();
    }

    public <O> Result<O> convertTo(Transcoder<O> var1, D var2);

    public static interface ListBuilder<D> {
        public ListBuilder<D> add(D var1);

        public D build();
    }

    public static interface MapBuilder<D> {
        public MapBuilder<D> put(D var1, D var2);

        public MapBuilder<D> put(String var1, D var2);

        public D build();
    }

    public static interface MapLike<D> {
        @Contract(pure=true)
        public @Unmodifiable Collection<String> keys();

        @Contract(pure=true)
        public boolean hasValue(String var1);

        public Result<D> getValue(String var1);

        @Contract(pure=true)
        default public int size() {
            return this.keys().size();
        }

        @Contract(pure=true)
        default public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

