/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.codec;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.Transcoder;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class TranscoderJavaImpl
implements Transcoder<Object> {
    public static final Transcoder<Object> INSTANCE = new TranscoderJavaImpl();

    TranscoderJavaImpl() {
    }

    @Override
    public Object createNull() {
        return Optional.empty();
    }

    @Override
    public Result<Boolean> getBoolean(Object value) {
        if (!(value instanceof Boolean)) {
            return new Result.Error<Boolean>("Not a boolean: " + String.valueOf(value));
        }
        Boolean b = (Boolean)value;
        return new Result.Ok<Boolean>(b);
    }

    @Override
    public Object createBoolean(boolean value) {
        return value;
    }

    @Override
    public Result<Byte> getByte(Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Byte>("Not a byte: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Byte>(n.byteValue());
    }

    @Override
    public Object createByte(byte value) {
        return value;
    }

    @Override
    public Result<Short> getShort(Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Short>("Not a short: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Short>(n.shortValue());
    }

    @Override
    public Object createShort(short value) {
        return value;
    }

    @Override
    public Result<Integer> getInt(Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Integer>("Not an int: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Integer>(n.intValue());
    }

    @Override
    public Object createInt(int value) {
        return value;
    }

    @Override
    public Result<Long> getLong(Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Long>("Not a long: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Long>(n.longValue());
    }

    @Override
    public Object createLong(long value) {
        return value;
    }

    @Override
    public Result<Float> getFloat(Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Float>("Not a float: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Float>(Float.valueOf(n.floatValue()));
    }

    @Override
    public Object createFloat(float value) {
        return Float.valueOf(value);
    }

    @Override
    public Result<Double> getDouble(Object value) {
        if (!(value instanceof Number)) {
            return new Result.Error<Double>("Not a double: " + String.valueOf(value));
        }
        Number n = (Number)value;
        return new Result.Ok<Double>(n.doubleValue());
    }

    @Override
    public Object createDouble(double value) {
        return value;
    }

    @Override
    public Result<String> getString(Object value) {
        if (!(value instanceof String)) {
            return new Result.Error<String>("Not a string: " + String.valueOf(value));
        }
        String s = (String)value;
        return new Result.Ok<String>(s);
    }

    @Override
    public Object createString(String value) {
        return value;
    }

    @Override
    public Result<List<Object>> getList(Object value) {
        if (!(value instanceof List)) {
            return new Result.Error<List<Object>>("Not a list: " + String.valueOf(value));
        }
        List list = (List)value;
        return new Result.Ok<List<Object>>(list);
    }

    @Override
    public Transcoder.ListBuilder<Object> createList(int expectedSize) {
        final ArrayList list = new ArrayList(expectedSize);
        return new Transcoder.ListBuilder<Object>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Transcoder.ListBuilder<Object> add(Object value) {
                list.add(value);
                return this;
            }

            @Override
            public Object build() {
                return List.copyOf(list);
            }
        };
    }

    @Override
    public Object emptyList() {
        return List.of();
    }

    @Override
    public Result<Transcoder.MapLike<Object>> getMap(Object value) {
        if (!(value instanceof Map)) {
            return new Result.Error<Transcoder.MapLike<Object>>("Not a map: " + String.valueOf(value));
        }
        final Map map = (Map)value;
        return new Result.Ok<Transcoder.MapLike<Object>>(new Transcoder.MapLike<Object>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Collection<String> keys() {
                if (map.isEmpty()) {
                    return List.of();
                }
                List<String> keys = List.copyOf(map.keySet());
                if (keys.getFirst() instanceof String) {
                    return keys;
                }
                return List.of();
            }

            @Override
            public boolean hasValue(String key) {
                return map.containsKey(key);
            }

            @Override
            public Result<Object> getValue(String key) {
                if (!this.hasValue(key)) {
                    return new Result.Error<Object>("No such key: " + key);
                }
                return new Result.Ok<Object>(map.get(key));
            }
        });
    }

    @Override
    public Transcoder.MapBuilder<Object> createMap() {
        final HashMap map = new HashMap();
        return new Transcoder.MapBuilder<Object>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public Transcoder.MapBuilder<Object> put(Object key, Object value) {
                if (!(key instanceof String)) {
                    return this;
                }
                String s = (String)key;
                map.put(s, value);
                return this;
            }

            @Override
            public Transcoder.MapBuilder<Object> put(String key, Object value) {
                map.put(key, value);
                return this;
            }

            @Override
            public Object build() {
                return Map.copyOf(map);
            }
        };
    }

    @Override
    public Object emptyMap() {
        return Map.of();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <O> Result<O> convertTo(Transcoder<O> coder, Object value) {
        Result.Error error;
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        block17: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Optional.class, Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Number.class, String.class, List.class, Map.class}, (Object)object2, n)) {
                case 0: {
                    Optional o = (Optional)object2;
                    if (o.isEmpty()) {
                        error = new Result.Ok<O>(coder.createNull());
                        return error;
                    }
                    n = 1;
                    continue block17;
                }
                case 1: {
                    Boolean b = (Boolean)object2;
                    error = new Result.Ok<O>(coder.createBoolean(b));
                    return error;
                }
                case 2: {
                    Byte n2 = (Byte)object2;
                    error = new Result.Ok<O>(coder.createByte(n2));
                    return error;
                }
                case 3: {
                    Short n3 = (Short)object2;
                    error = new Result.Ok<O>(coder.createShort(n3));
                    return error;
                }
                case 4: {
                    Integer n4 = (Integer)object2;
                    error = new Result.Ok<O>(coder.createInt(n4));
                    return error;
                }
                case 5: {
                    Long n5 = (Long)object2;
                    error = new Result.Ok<O>(coder.createLong(n5));
                    return error;
                }
                case 6: {
                    Float n6 = (Float)object2;
                    error = new Result.Ok<O>(coder.createFloat(n6.floatValue()));
                    return error;
                }
                case 7: {
                    Double n7 = (Double)object2;
                    error = new Result.Ok<O>(coder.createDouble(n7));
                    return error;
                }
                case 8: {
                    Number n8 = (Number)object2;
                    error = new Result.Ok<O>(coder.createDouble(n8.doubleValue()));
                    return error;
                }
                case 9: {
                    String s = (String)object2;
                    error = new Result.Ok<O>(coder.createString(s));
                    return error;
                }
                case 10: {
                    List l = (List)object2;
                    Transcoder.ListBuilder<O> builder = coder.createList(l.size());
                    Iterator iterator = l.iterator();
                    while (true) {
                        Object inner;
                        if (!iterator.hasNext()) {
                            error = new Result.Ok<O>(builder.build());
                            return error;
                        }
                        Object o = iterator.next();
                        Result<O> result = this.convertTo(coder, o);
                        if (!(result instanceof Result.Ok)) {
                            error = result.cast();
                            return error;
                        }
                        Result.Ok ok = (Result.Ok)result;
                        try {
                            Object t;
                            inner = t = ok.value();
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                        builder.add(inner);
                    }
                }
                case 11: {
                    Map m = (Map)object2;
                    Transcoder.MapBuilder<O> builder = coder.createMap();
                    Iterator iterator = m.entrySet().iterator();
                    while (true) {
                        Object inner;
                        if (!iterator.hasNext()) {
                            error = new Result.Ok<O>(builder.build());
                            return error;
                        }
                        Map.Entry entry = iterator.next();
                        Object key = entry.getKey();
                        if (!(key instanceof String)) {
                            error = new Result.Error("Map key is not a string: " + String.valueOf(key));
                            return error;
                        }
                        String s = (String)key;
                        Result<O> result = this.convertTo(coder, entry.getValue());
                        if (!(result instanceof Result.Ok)) {
                            error = result.cast();
                            return error;
                        }
                        Result.Ok ok = (Result.Ok)result;
                        {
                            Object t;
                            inner = t = ok.value();
                        }
                        builder.put(s, inner);
                    }
                }
            }
            break;
        }
        error = new Result.Error("Unsupported type: " + String.valueOf(value));
        return error;
    }
}

