/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import it.unimi.dsi.fastutil.doubles.DoubleUnaryOperator;
import org.jetbrains.annotations.Contract;

public record Aerodynamics(double gravity, double horizontalAirResistance, double verticalAirResistance) {
    @Contract(pure=true)
    public Aerodynamics withGravity(double gravity) {
        return new Aerodynamics(gravity, this.horizontalAirResistance, this.verticalAirResistance);
    }

    @Contract(pure=true)
    public Aerodynamics withGravity(DoubleUnaryOperator operator) {
        return this.withGravity(operator.apply(this.gravity));
    }

    @Contract(pure=true)
    public Aerodynamics withHorizontalAirResistance(double horizontalAirResistance) {
        return new Aerodynamics(this.gravity, horizontalAirResistance, this.verticalAirResistance);
    }

    @Contract(pure=true)
    public Aerodynamics withHorizontalAirResistance(DoubleUnaryOperator operator) {
        return this.withHorizontalAirResistance(operator.apply(this.horizontalAirResistance));
    }

    @Contract(pure=true)
    public Aerodynamics withVerticalAirResistance(double verticalAirResistance) {
        return new Aerodynamics(this.gravity, this.horizontalAirResistance, verticalAirResistance);
    }

    @Contract(pure=true)
    public Aerodynamics withVerticalAirResistance(DoubleUnaryOperator operator) {
        return this.withVerticalAirResistance(operator.apply(this.verticalAirResistance));
    }

    @Contract(pure=true)
    public Aerodynamics withAirResistance(double horizontalAirResistance, double verticalAirResistance) {
        return new Aerodynamics(this.gravity, horizontalAirResistance, verticalAirResistance);
    }
}

