/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import net.minestom.server.collision.BlockCollision;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.EntityCollision;
import net.minestom.server.collision.EntityCollisionResult;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.collision.Shape;
import net.minestom.server.collision.ShapeImpl;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.WorldBorder;
import net.minestom.server.instance.block.Block;
import net.minestom.server.utils.chunk.ChunkCache;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CollisionUtils {
    public static PhysicsResult handlePhysics(Entity entity, Vec entityVelocity, @Nullable PhysicsResult lastPhysicsResult, boolean singleCollision) {
        Instance instance = entity.getInstance();
        assert (instance != null);
        return CollisionUtils.handlePhysics(instance, entity.getChunk(), entity.getBoundingBox(), entity.getPosition(), entityVelocity, lastPhysicsResult, singleCollision);
    }

    public static Collection<EntityCollisionResult> checkEntityCollisions(Instance instance, BoundingBox boundingBox, Point pos, Vec velocity, double extendRadius, Function<Entity, Boolean> entityFilter, @Nullable PhysicsResult physicsResult) {
        return EntityCollision.checkCollision(instance, boundingBox, pos, velocity, extendRadius, entityFilter, physicsResult);
    }

    public static Collection<EntityCollisionResult> checkEntityCollisions(Entity entity, Vec velocity, double extendRadius, Function<Entity, Boolean> entityFilter, @Nullable PhysicsResult physicsResult) {
        return EntityCollision.checkCollision(entity.getInstance(), entity.getBoundingBox(), entity.getPosition(), velocity, extendRadius, entityFilter, physicsResult);
    }

    public static PhysicsResult handlePhysics(Entity entity, Vec entityVelocity, @Nullable PhysicsResult lastPhysicsResult) {
        Instance instance = entity.getInstance();
        assert (instance != null);
        return CollisionUtils.handlePhysics(instance, entity.getChunk(), entity.getBoundingBox(), entity.getPosition(), entityVelocity, lastPhysicsResult, false);
    }

    public static PhysicsResult handlePhysics(Instance instance, @Nullable Chunk chunk, BoundingBox boundingBox, Pos position, Vec velocity, @Nullable PhysicsResult lastPhysicsResult, boolean singleCollision) {
        ChunkCache getter = new ChunkCache(instance, chunk != null ? chunk : instance.getChunkAt(position), Block.STONE);
        return CollisionUtils.handlePhysics(getter, boundingBox, position, velocity, lastPhysicsResult, singleCollision);
    }

    @ApiStatus.Internal
    public static PhysicsResult handlePhysics(Block.Getter blockGetter, BoundingBox boundingBox, Pos position, Vec velocity, @Nullable PhysicsResult lastPhysicsResult, boolean singleCollision) {
        return BlockCollision.handlePhysics(boundingBox, velocity, position, blockGetter, lastPhysicsResult, singleCollision);
    }

    public static boolean isLineOfSightReachingShape(Instance instance, @Nullable Chunk chunk, Point start, Point end, Shape shape, Point shapePos) {
        PhysicsResult result = CollisionUtils.handlePhysics(instance, chunk, BoundingBox.ZERO, start.asPos(), end.sub(start).asVec(), null, false);
        return shape.intersectBox(shapePos.sub(result.newPosition()).sub(1.0E-6), BoundingBox.ZERO);
    }

    public static PhysicsResult handlePhysics(Entity entity, Vec entityVelocity) {
        return CollisionUtils.handlePhysics(entity, entityVelocity, null);
    }

    public static Entity canPlaceBlockAt(Instance instance, Point blockPos, Block b) {
        return BlockCollision.canPlaceBlockAt(instance, blockPos, b);
    }

    public static Pos applyWorldBorder(WorldBorder worldBorder, Pos currentPosition, Pos newPosition) {
        boolean zCollision;
        double radius = worldBorder.diameter() / 2.0;
        boolean xCollision = newPosition.x() > worldBorder.centerX() + radius || newPosition.x() < worldBorder.centerX() - radius;
        boolean bl = zCollision = newPosition.z() > worldBorder.centerZ() + radius || newPosition.z() < worldBorder.centerZ() - radius;
        if (xCollision || zCollision) {
            return newPosition.withCoord(xCollision ? currentPosition.x() : newPosition.x(), newPosition.y(), zCollision ? currentPosition.z() : newPosition.z());
        }
        return newPosition;
    }

    @ApiStatus.Internal
    public static Shape parseCollisionShape(Map<Object, Object> internCache, String shape) {
        Shape cachedShape = (Shape)internCache.get(shape);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl parsedShape = ShapeImpl.parseShapeFromRegistry(shape, (byte)0);
        internCache.put(shape, parsedShape);
        return (Shape)internCache.computeIfAbsent(parsedShape, k -> parsedShape);
    }

    @ApiStatus.Internal
    public static Shape parseOcclusionShape(Map<Object, Object> internCache, String shape, boolean occludes, byte lightEmission) {
        record ShapeEntry(String shape, boolean occludes, byte lightEmission) {
        }
        ShapeEntry entry = new ShapeEntry(shape, occludes, lightEmission);
        Shape cachedShape = (Shape)internCache.get(entry);
        if (cachedShape != null) {
            return cachedShape;
        }
        ShapeImpl parsedShape = occludes ? ShapeImpl.parseShapeFromRegistry(shape, lightEmission) : ShapeImpl.emptyShape(lightEmission);
        internCache.put(entry, parsedShape);
        return (Shape)internCache.computeIfAbsent(parsedShape, k -> parsedShape);
    }

    public static PhysicsResult blocklessCollision(Pos entityPosition, Vec entityVelocity) {
        return new PhysicsResult(entityPosition.add(entityVelocity), entityVelocity, false, false, false, false, entityVelocity, new Point[3], new Shape[3], new Point[3], false, SweepResult.NO_COLLISION);
    }
}

