/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.collision;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.EntityCollisionResult;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.collision.SweepResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.instance.Instance;
import org.jetbrains.annotations.Nullable;

final class EntityCollision {
    EntityCollision() {
    }

    static List<EntityCollisionResult> checkCollision(Instance instance, BoundingBox boundingBox, Point point, Vec entityVelocity, double extendRadius, Function<Entity, Boolean> entityFilter, @Nullable PhysicsResult physicsResult) {
        double minimumRes = physicsResult != null ? physicsResult.res().res : Double.MAX_VALUE;
        ArrayList<EntityCollisionResult> result = new ArrayList<EntityCollisionResult>();
        double maxDistance = Math.pow(boundingBox.height() * boundingBox.height() + boundingBox.depth() / 2.0 * boundingBox.depth() / 2.0 + boundingBox.width() / 2.0 * boundingBox.width() / 2.0, 0.3333333333333333);
        double projectileDistance = entityVelocity.length();
        for (Entity e : instance.getNearbyEntities(point, extendRadius + maxDistance + projectileDistance)) {
            SweepResult sweepResult = new SweepResult(minimumRes, 0.0, 0.0, 0.0, null, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            if (!entityFilter.apply(e).booleanValue() || !e.hasEntityCollision()) continue;
            if (e.getBoundingBox().intersectBox(e.getPosition().sub(point), boundingBox)) {
                Pos p = point.asPos();
                result.add(new EntityCollisionResult(p, e, Vec.ZERO, 0.0));
                continue;
            }
            boolean intersected = e.getBoundingBox().intersectBoxSwept(point, entityVelocity, e.getPosition(), boundingBox, sweepResult);
            if (!intersected || !(sweepResult.res < 1.0)) continue;
            Pos p = point.asPos().add(entityVelocity.mul(sweepResult.res));
            Vec direction = new Vec(sweepResult.collidedPositionX, sweepResult.collidedPositionY, sweepResult.collidedPositionZ);
            result.add(new EntityCollisionResult(p, e, direction, sweepResult.res));
        }
        return result;
    }
}

