/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.GraphImpl;
import net.minestom.server.command.builder.Command;
import net.minestom.server.command.builder.CommandExecutor;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.condition.CommandCondition;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

sealed interface Graph
permits GraphImpl {
    public static Builder builder(Argument<?> argument, @Nullable Execution execution) {
        return new GraphImpl.BuilderImpl(argument, execution);
    }

    public static Builder builder(Argument<?> argument) {
        return new GraphImpl.BuilderImpl(argument, null);
    }

    public static Graph fromCommand(Command command) {
        return GraphImpl.fromCommand(command);
    }

    public static Graph merge(Collection<Command> commands) {
        return GraphImpl.merge(commands);
    }

    public static Graph merge(List<Graph> graphs) {
        return GraphImpl.merge(graphs);
    }

    public static Graph merge(Graph ... graphs) {
        return Graph.merge(List.of(graphs));
    }

    public Node root();

    public boolean compare(Graph var1, Comparator var2);

    public static sealed interface Execution
    extends Predicate<CommandSender>
    permits GraphImpl.ExecutionImpl {
        public @UnknownNullability CommandExecutor defaultExecutor();

        public @UnknownNullability CommandExecutor globalListener();

        @Nullable
        public CommandExecutor executor();

        @Nullable
        public CommandCondition condition();
    }

    public static enum Comparator {
        TREE;

    }

    public static sealed interface Builder
    permits GraphImpl.BuilderImpl {
        public Builder append(Argument<?> var1, @Nullable Execution var2, Consumer<Builder> var3);

        public Builder append(Argument<?> var1, @Nullable Execution var2);

        default public Builder append(Argument<?> argument, Consumer<Builder> consumer) {
            return this.append(argument, null, consumer);
        }

        default public Builder append(Argument<?> argument) {
            return this.append(argument, (Execution)null);
        }

        public Graph build();
    }

    public static sealed interface Node
    permits GraphImpl.NodeImpl {
        public Argument<?> argument();

        public @UnknownNullability Execution execution();

        public List<Node> next();
    }
}

