/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minestom.server.command.ArgumentParserType;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.ArgumentCallback;
import net.minestom.server.command.builder.arguments.minecraft.SuggestionType;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;
import net.minestom.server.command.builder.suggestion.SuggestionCallback;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class Argument<T> {
    private final String id;
    protected final boolean allowSpace;
    protected final boolean useRemaining;
    @Nullable
    private ArgumentCallback callback;
    @Nullable
    private Function<CommandSender, T> defaultValue;
    @Nullable
    private SuggestionCallback suggestionCallback;
    @Nullable
    protected SuggestionType suggestionType;

    public Argument(String id, boolean allowSpace, boolean useRemaining) {
        this.id = id;
        this.allowSpace = allowSpace;
        this.useRemaining = useRemaining;
    }

    public Argument(String id, boolean allowSpace) {
        this(id, allowSpace, false);
    }

    public Argument(String id) {
        this(id, false, false);
    }

    public static <T> T parse(CommandSender sender, Argument<T> argument) throws ArgumentSyntaxException {
        return argument.parse(sender, argument.getId());
    }

    public abstract T parse(CommandSender var1, String var2) throws ArgumentSyntaxException;

    public abstract ArgumentParserType parser();

    public byte @Nullable [] nodeProperties() {
        return null;
    }

    @Nullable
    public SuggestionType suggestionType() {
        return this.suggestionType;
    }

    public String getId() {
        return this.id;
    }

    public boolean allowSpace() {
        return this.allowSpace;
    }

    public boolean useRemaining() {
        return this.useRemaining;
    }

    @Nullable
    public ArgumentCallback getCallback() {
        return this.callback;
    }

    public void setCallback(@Nullable ArgumentCallback callback) {
        this.callback = callback;
    }

    public boolean hasErrorCallback() {
        return this.callback != null;
    }

    public boolean isOptional() {
        return this.defaultValue != null;
    }

    @Nullable
    public Function<CommandSender, T> getDefaultValue() {
        return this.defaultValue;
    }

    public Argument<T> setDefaultValue(@Nullable Supplier<T> defaultValue) {
        this.defaultValue = defaultValue == null ? null : unused -> defaultValue.get();
        return this;
    }

    public Argument<T> setDefaultValue(@Nullable Function<CommandSender, T> defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public Argument<T> setDefaultValue(T defaultValue) {
        this.defaultValue = unused -> defaultValue;
        return this;
    }

    @Nullable
    public SuggestionCallback getSuggestionCallback() {
        return this.suggestionCallback;
    }

    public Argument<T> setSuggestionCallback(SuggestionCallback suggestionCallback) {
        this.suggestionCallback = suggestionCallback;
        this.suggestionType = SuggestionType.ASK_SERVER;
        return this;
    }

    public boolean hasSuggestion() {
        return this.suggestionType != null;
    }

    public <O> Argument<O> map(Function<T, O> mapper) {
        return new ArgumentMap<Object, Object>(this, (p, i) -> mapper.apply(i));
    }

    public <O> Argument<O> map(BiFunction<CommandSender, T, O> mapper) {
        return new ArgumentMap<T, O>(this, mapper);
    }

    @ApiStatus.Experimental
    public Argument<T> filter(Predicate<T> predicate) {
        return new ArgumentFilter<T>(this, predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Argument argument = (Argument)o;
        return this.id.equals(argument.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private static final class ArgumentMap<I, O>
    extends Argument<O> {
        public static final int INVALID_MAP = 555;
        final Argument<I> argument;
        final BiFunction<CommandSender, I, O> mapper;

        private ArgumentMap(Argument<I> argument, BiFunction<CommandSender, I, O> mapper) {
            super(argument.getId(), argument.allowSpace(), argument.useRemaining());
            if (argument.getSuggestionCallback() != null) {
                this.setSuggestionCallback(argument.getSuggestionCallback());
            }
            if (argument.getDefaultValue() != null) {
                this.setDefaultValue(sender -> mapper.apply((CommandSender)sender, (Object)argument.getDefaultValue().apply((CommandSender)sender)));
            }
            this.argument = argument;
            this.mapper = mapper;
        }

        @Override
        public O parse(CommandSender sender, String input) throws ArgumentSyntaxException {
            I value = this.argument.parse(sender, input);
            O mappedValue = this.mapper.apply(sender, value);
            if (mappedValue == null) {
                throw new ArgumentSyntaxException("Couldn't be converted to map type", input, 555);
            }
            return mappedValue;
        }

        @Override
        public ArgumentParserType parser() {
            return this.argument.parser();
        }

        @Override
        public byte @Nullable [] nodeProperties() {
            return this.argument.nodeProperties();
        }
    }

    private static final class ArgumentFilter<T>
    extends Argument<T> {
        public static final int INVALID_FILTER = 556;
        final Argument<T> argument;
        final Predicate<T> predicate;

        private ArgumentFilter(Argument<T> argument, Predicate<T> predicate) {
            super(argument.getId(), argument.allowSpace(), argument.useRemaining());
            if (argument.getSuggestionCallback() != null) {
                this.setSuggestionCallback(argument.getSuggestionCallback());
            }
            if (argument.getDefaultValue() != null) {
                this.setDefaultValue(argument.getDefaultValue());
            }
            this.argument = argument;
            this.predicate = predicate;
        }

        @Override
        public T parse(CommandSender sender, String input) throws ArgumentSyntaxException {
            T result = this.argument.parse(sender, input);
            if (!this.predicate.test(result)) {
                throw new ArgumentSyntaxException("Predicate failed", input, 556);
            }
            return result;
        }

        @Override
        public ArgumentParserType parser() {
            return this.argument.parser();
        }

        @Override
        public byte @Nullable [] nodeProperties() {
            return this.argument.nodeProperties();
        }
    }
}

