/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.arguments.minecraft;

import java.io.IOException;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.minestom.server.adventure.MinestomAdventure;
import net.minestom.server.command.ArgumentParserType;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.exception.ArgumentSyntaxException;

public class ArgumentNbtCompoundTag
extends Argument<CompoundBinaryTag> {
    public static final int INVALID_NBT = 1;

    public ArgumentNbtCompoundTag(String id) {
        super(id, true);
    }

    @Override
    public CompoundBinaryTag parse(CommandSender sender, String input) throws ArgumentSyntaxException {
        try {
            return MinestomAdventure.tagStringIO().asCompound(input);
        }
        catch (IOException e) {
            throw new ArgumentSyntaxException("NBTCompound is invalid", input, 1);
        }
    }

    @Override
    public ArgumentParserType parser() {
        return ArgumentParserType.NBT_COMPOUND_TAG;
    }

    public String toString() {
        return String.format("NbtCompound<%s>", this.getId());
    }
}

