/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.condition;

import net.minestom.server.command.CommandSender;
import net.minestom.server.command.ConsoleSender;
import net.minestom.server.command.builder.condition.CommandCondition;
import net.minestom.server.entity.Player;
import net.minestom.server.utils.validate.Check;

public class Conditions {
    public static CommandCondition all(CommandCondition ... conditions) {
        Check.notNull(conditions, "conditions cannot be null");
        for (CommandCondition condition : conditions) {
            Check.notNull(condition, "condition cannot be null");
        }
        return (sender, commandString) -> {
            for (CommandCondition condition : conditions) {
                if (condition.canUse(sender, commandString)) continue;
                return false;
            }
            return true;
        };
    }

    public static CommandCondition any(CommandCondition ... conditions) {
        Check.notNull(conditions, "conditions cannot be null");
        for (CommandCondition condition : conditions) {
            Check.notNull(condition, "condition cannot be null");
        }
        return (sender, commandString) -> {
            for (CommandCondition condition : conditions) {
                if (!condition.canUse(sender, commandString)) continue;
                return true;
            }
            return false;
        };
    }

    public static boolean playerOnly(CommandSender sender, String commandString) {
        return sender instanceof Player;
    }

    public static boolean consoleOnly(CommandSender sender, String commandString) {
        return sender instanceof ConsoleSender;
    }

    public static CommandCondition not(CommandCondition condition) {
        Check.notNull(condition, "condition cannot be null");
        return (sender, commandString) -> !condition.canUse(sender, commandString);
    }
}

