/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.command.builder.parser;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minestom.server.command.CommandSender;
import net.minestom.server.command.builder.Command;
import net.minestom.server.command.builder.CommandContext;
import net.minestom.server.command.builder.CommandDispatcher;
import net.minestom.server.command.builder.CommandSyntax;
import net.minestom.server.command.builder.arguments.Argument;
import net.minestom.server.command.builder.parser.ArgumentParser;
import net.minestom.server.command.builder.parser.ArgumentQueryResult;
import net.minestom.server.command.builder.parser.CommandQueryResult;
import net.minestom.server.command.builder.parser.CommandSuggestionHolder;
import net.minestom.server.command.builder.parser.ValidSyntaxHolder;
import org.jetbrains.annotations.Nullable;

public final class CommandParser {
    @Nullable
    private static CommandQueryResult recursiveCommandQuery(CommandDispatcher dispatcher, List<Command> parents, @Nullable Command parentCommand, String commandName, String[] args) {
        Command command;
        Command command2 = command = parentCommand == null ? dispatcher.findCommand(commandName) : parentCommand;
        if (command == null) {
            return null;
        }
        CommandQueryResult commandQueryResult = new CommandQueryResult(parents, command, commandName, args);
        if (args.length > 0) {
            String subCommandName = args[0];
            for (Command subcommand : command.getSubcommands()) {
                if (!Command.isValidName(subcommand, subCommandName)) continue;
                String[] subArgs = Arrays.copyOfRange(args, 1, args.length);
                parents.add(command);
                return CommandParser.recursiveCommandQuery(dispatcher, parents, subcommand, subCommandName, subArgs);
            }
        }
        return commandQueryResult;
    }

    @Nullable
    public static CommandQueryResult findCommand(CommandDispatcher dispatcher, String input) {
        String[] parts = input.split(" ");
        String commandName = parts[0];
        String[] args = new String[parts.length - 1];
        System.arraycopy(parts, 1, args, 0, args.length);
        ArrayList<Command> parents = new ArrayList<Command>();
        return CommandParser.recursiveCommandQuery(dispatcher, parents, null, commandName, args);
    }

    public static void parse(CommandSender sender, @Nullable CommandSyntax syntax, Argument<?>[] commandArguments, String[] inputArguments, String commandString, @Nullable List<ValidSyntaxHolder> validSyntaxes, @Nullable Int2ObjectRBTreeMap<CommandSuggestionHolder> syntaxesSuggestions) {
        Argument<?> argument;
        ArgumentParser.ArgumentResult argumentResult;
        HashMap argumentValueMap = new HashMap();
        boolean syntaxCorrect = true;
        int inputIndex = 0;
        boolean useRemaining = false;
        for (int argIndex = 0; argIndex < commandArguments.length && (argumentResult = ArgumentParser.validate(sender, argument = commandArguments[argIndex], commandArguments, argIndex, inputArguments, inputIndex)) != null; ++argIndex) {
            useRemaining = argumentResult.useRemaining;
            inputIndex = argumentResult.inputIndex;
            if (!argumentResult.correct) {
                syntaxCorrect = false;
                if (syntaxesSuggestions == null) break;
                syntaxesSuggestions.put(argIndex, new CommandSuggestionHolder(syntax, argumentResult.argumentSyntaxException, argIndex));
                break;
            }
            argumentValueMap.put(argumentResult.argument, argumentResult);
        }
        if (syntaxCorrect && (commandArguments.length == argumentValueMap.size() || useRemaining) && validSyntaxes != null) {
            validSyntaxes.add(new ValidSyntaxHolder(commandString, syntax, argumentValueMap));
        }
    }

    @Nullable
    public static ValidSyntaxHolder findMostCorrectSyntax(List<ValidSyntaxHolder> validSyntaxes, CommandContext context) {
        if (validSyntaxes.isEmpty()) {
            return null;
        }
        ValidSyntaxHolder finalSyntax = null;
        int maxArguments = 0;
        CommandContext finalContext = null;
        for (ValidSyntaxHolder validSyntaxHolder : validSyntaxes) {
            Map<Argument<?>, ArgumentParser.ArgumentResult> argsValues = validSyntaxHolder.argumentResults();
            int argsSize = argsValues.size();
            if (argsSize <= maxArguments) continue;
            finalSyntax = validSyntaxHolder;
            maxArguments = argsSize;
            finalContext = new CommandContext(validSyntaxHolder.commandString());
            for (Map.Entry<Argument<?>, ArgumentParser.ArgumentResult> entry : argsValues.entrySet()) {
                Argument<?> argument = entry.getKey();
                ArgumentParser.ArgumentResult argumentResult = entry.getValue();
                finalContext.setArg(argument.getId(), argumentResult.parsedValue, argumentResult.rawArg);
            }
        }
        if (finalSyntax != null) {
            context.copy(finalContext);
        }
        return finalSyntax;
    }

    @Nullable
    public static ArgumentQueryResult findEligibleArgument(CommandSender sender, Command command, String[] args, String commandString, boolean trailingSpace, boolean forceCorrect, Predicate<CommandSyntax> syntaxPredicate, Predicate<Argument<?>> argumentPredicate) {
        Collection<CommandSyntax> syntaxes = command.getSyntaxes();
        Int2ObjectRBTreeMap<ArgumentQueryResult> suggestions = new Int2ObjectRBTreeMap<ArgumentQueryResult>(Collections.reverseOrder());
        for (CommandSyntax syntax : syntaxes) {
            if (!syntaxPredicate.test(syntax)) continue;
            CommandContext context = new CommandContext(commandString);
            Argument<?>[] commandArguments = syntax.getArguments();
            int inputIndex = 0;
            ArgumentQueryResult maxArg = null;
            int maxArgIndex = 0;
            for (int argIndex = 0; argIndex < commandArguments.length; ++argIndex) {
                boolean isLast;
                Argument<?> argument = commandArguments[argIndex];
                ArgumentParser.ArgumentResult argumentResult = ArgumentParser.validate(sender, argument, commandArguments, argIndex, args, inputIndex);
                if (argumentResult == null) {
                    argumentResult = new ArgumentParser.ArgumentResult();
                    argumentResult.argument = argument;
                    argumentResult.correct = false;
                    argumentResult.inputIndex = inputIndex;
                    argumentResult.rawArg = "";
                }
                inputIndex = argumentResult.inputIndex;
                if (argumentResult.correct) {
                    context.setArg(argument.getId(), argumentResult.parsedValue, argumentResult.rawArg);
                }
                if ((!forceCorrect || argumentResult.correct) && argumentPredicate.test(argument)) {
                    maxArg = new ArgumentQueryResult(syntax, argument, context, argumentResult.rawArg);
                    maxArgIndex = argIndex;
                }
                if (!argumentResult.correct) break;
                boolean bl = isLast = inputIndex == args.length;
                if (isLast && !trailingSpace) break;
            }
            if (maxArg == null) continue;
            suggestions.put(maxArgIndex, maxArg);
        }
        if (suggestions.isEmpty()) {
            return null;
        }
        int max = suggestions.firstIntKey();
        return (ArgumentQueryResult)suggestions.get(max);
    }
}

