/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import java.util.function.DoubleUnaryOperator;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.MathUtils;
import net.minestom.server.utils.position.PositionUtils;
import org.jetbrains.annotations.Contract;

public record Pos(double x, double y, double z, float yaw, float pitch) implements Point
{
    public static final Pos ZERO = new Pos(0.0, 0.0, 0.0);

    public Pos {
        yaw = Pos.fixYaw(yaw);
    }

    public Pos(double x, double y, double z) {
        this(x, y, z, 0.0f, 0.0f);
    }

    public Pos(Point point, float yaw, float pitch) {
        this(point.x(), point.y(), point.z(), yaw, pitch);
    }

    public Pos(Point point) {
        this(point, 0.0f, 0.0f);
    }

    @Deprecated
    public static Pos fromPoint(Point point) {
        if (point instanceof Pos) {
            Pos pos = (Pos)point;
            return pos;
        }
        return new Pos(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    public Pos withCoord(double x, double y, double z) {
        return new Pos(x, y, z, this.yaw, this.pitch);
    }

    @Contract(pure=true)
    public Pos withCoord(Point point) {
        return this.withCoord(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    public Pos withView(float yaw, float pitch) {
        return new Pos(this.x, this.y, this.z, yaw, pitch);
    }

    @Contract(pure=true)
    public Pos withView(Pos pos) {
        return this.withView(pos.yaw(), pos.pitch());
    }

    @Contract(pure=true)
    public Pos withDirection(Point point) {
        double x = point.x();
        double z = point.z();
        if (x == 0.0 && z == 0.0) {
            return this.withPitch(point.y() > 0.0 ? -90.0f : 90.0f);
        }
        double theta = Math.atan2(-x, z);
        double xz = Math.sqrt(MathUtils.square(x) + MathUtils.square(z));
        double _2PI = Math.PI * 2;
        return this.withView((float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2)), (float)Math.toDegrees(Math.atan(-point.y() / xz)));
    }

    @Contract(pure=true)
    public Pos withYaw(float yaw) {
        return new Pos(this.x, this.y, this.z, yaw, this.pitch);
    }

    @Contract(pure=true)
    public Pos withYaw(DoubleUnaryOperator operator) {
        return this.withYaw((float)operator.applyAsDouble(this.yaw));
    }

    @Contract(pure=true)
    public Pos withPitch(float pitch) {
        return new Pos(this.x, this.y, this.z, this.yaw, pitch);
    }

    @Contract(pure=true)
    public Pos withLookAt(Point point) {
        if (this.samePoint(point)) {
            return this;
        }
        Vec delta = point.sub(this).asVec().normalize();
        return this.withView(PositionUtils.getLookYaw(delta.x(), delta.z()), PositionUtils.getLookPitch(delta.x(), delta.y(), delta.z()));
    }

    @Contract(pure=true)
    public Pos withPitch(DoubleUnaryOperator operator) {
        return this.withPitch((float)operator.applyAsDouble(this.pitch));
    }

    public boolean sameView(Pos position) {
        return this.sameView(position.yaw(), position.pitch());
    }

    public boolean sameView(float yaw, float pitch) {
        return Float.compare(this.yaw, yaw) == 0 && Float.compare(this.pitch, pitch) == 0;
    }

    public Vec direction() {
        float rotX = this.yaw;
        float rotY = this.pitch;
        double xz = Math.cos(Math.toRadians(rotY));
        return new Vec(-xz * Math.sin(Math.toRadians(rotX)), -Math.sin(Math.toRadians(rotY)), xz * Math.cos(Math.toRadians(rotX)));
    }

    public Direction facing() {
        if (this.pitch < -45.0f) {
            return Direction.UP;
        }
        if (this.pitch > 45.0f) {
            return Direction.DOWN;
        }
        if (this.yaw > 135.0f || this.yaw <= -135.0f) {
            return Direction.NORTH;
        }
        if (-135.0f < this.yaw && this.yaw <= -45.0f) {
            return Direction.EAST;
        }
        if (-45.0f < this.yaw && this.yaw <= 45.0f) {
            return Direction.SOUTH;
        }
        if (45.0f < this.yaw) {
            return Direction.WEST;
        }
        throw new IllegalStateException("Illegal yaw (%s) or pitch (%s) value.".formatted(Float.valueOf(this.yaw), Float.valueOf(this.pitch)));
    }

    @Contract(pure=true)
    public Pos apply(Operator operator) {
        return operator.apply(this.x, this.y, this.z, this.yaw, this.pitch);
    }

    @Override
    @Contract(pure=true)
    public Pos withX(DoubleUnaryOperator operator) {
        return new Pos(operator.applyAsDouble(this.x), this.y, this.z, this.yaw, this.pitch);
    }

    @Override
    @Contract(pure=true)
    public Pos withX(double x) {
        return new Pos(x, this.y, this.z, this.yaw, this.pitch);
    }

    @Override
    @Contract(pure=true)
    public Pos withY(DoubleUnaryOperator operator) {
        return new Pos(this.x, operator.applyAsDouble(this.y), this.z, this.yaw, this.pitch);
    }

    @Override
    @Contract(pure=true)
    public Pos withY(double y) {
        return new Pos(this.x, y, this.z, this.yaw, this.pitch);
    }

    @Override
    @Contract(pure=true)
    public Pos withZ(DoubleUnaryOperator operator) {
        return new Pos(this.x, this.y, operator.applyAsDouble(this.z), this.yaw, this.pitch);
    }

    @Override
    @Contract(pure=true)
    public Pos withZ(double z) {
        return new Pos(this.x, this.y, z, this.yaw, this.pitch);
    }

    @Override
    public Pos add(double x, double y, double z) {
        return new Pos(this.x + x, this.y + y, this.z + z, this.yaw, this.pitch);
    }

    @Override
    public Pos add(Point point) {
        return this.add(point.x(), point.y(), point.z());
    }

    @Override
    public Pos add(double value) {
        return this.add(value, value, value);
    }

    @Override
    public Pos sub(double x, double y, double z) {
        return new Pos(this.x - x, this.y - y, this.z - z, this.yaw, this.pitch);
    }

    @Override
    public Pos sub(Point point) {
        return this.sub(point.x(), point.y(), point.z());
    }

    @Override
    public Pos sub(double value) {
        return this.sub(value, value, value);
    }

    @Override
    public Pos mul(double x, double y, double z) {
        return new Pos(this.x * x, this.y * y, this.z * z, this.yaw, this.pitch);
    }

    @Override
    public Pos mul(Point point) {
        return this.mul(point.x(), point.y(), point.z());
    }

    @Override
    public Pos mul(double value) {
        return this.mul(value, value, value);
    }

    @Override
    public Pos div(double x, double y, double z) {
        return new Pos(this.x / x, this.y / y, this.z / z, this.yaw, this.pitch);
    }

    @Override
    public Pos div(Point point) {
        return this.div(point.x(), point.y(), point.z());
    }

    @Override
    public Pos div(double value) {
        return this.div(value, value, value);
    }

    @Override
    public Pos relative(BlockFace face) {
        return (Pos)Point.super.relative(face);
    }

    public static float fixYaw(float yaw) {
        if ((yaw %= 360.0f) < -180.0f) {
            yaw += 360.0f;
        } else if (yaw > 180.0f) {
            yaw -= 360.0f;
        }
        return yaw;
    }

    @FunctionalInterface
    public static interface Operator {
        public Pos apply(double var1, double var3, double var5, float var7, float var8);
    }
}

