/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.coordinate;

import java.util.function.DoubleUnaryOperator;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.utils.Direction;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.Contract;

public record Vec(double x, double y, double z) implements Point
{
    public static final Vec ZERO = new Vec(0.0);
    public static final Vec ONE = new Vec(1.0);
    public static final Vec SECTION = new Vec(16.0);
    public static final double EPSILON = 1.0E-6;

    public Vec(double x, double z) {
        this(x, 0.0, z);
    }

    public Vec(double value) {
        this(value, value, value);
    }

    @Deprecated
    public static Vec fromPoint(Point point) {
        if (point instanceof Vec) {
            Vec vec = (Vec)point;
            return vec;
        }
        return new Vec(point.x(), point.y(), point.z());
    }

    @Contract(pure=true)
    public Vec apply(Operator operator) {
        return operator.apply(this.x, this.y, this.z);
    }

    @Override
    @Contract(pure=true)
    public Vec withX(DoubleUnaryOperator operator) {
        return new Vec(operator.applyAsDouble(this.x), this.y, this.z);
    }

    @Override
    @Contract(pure=true)
    public Vec withX(double x) {
        return new Vec(x, this.y, this.z);
    }

    @Override
    @Contract(pure=true)
    public Vec withY(DoubleUnaryOperator operator) {
        return new Vec(this.x, operator.applyAsDouble(this.y), this.z);
    }

    @Override
    @Contract(pure=true)
    public Vec withY(double y) {
        return new Vec(this.x, y, this.z);
    }

    @Override
    @Contract(pure=true)
    public Vec withZ(DoubleUnaryOperator operator) {
        return new Vec(this.x, this.y, operator.applyAsDouble(this.z));
    }

    @Override
    @Contract(pure=true)
    public Vec withZ(double z) {
        return new Vec(this.x, this.y, z);
    }

    @Override
    public Vec add(double x, double y, double z) {
        return new Vec(this.x + x, this.y + y, this.z + z);
    }

    @Override
    public Vec add(Point point) {
        return this.add(point.x(), point.y(), point.z());
    }

    @Override
    public Vec add(double value) {
        return this.add(value, value, value);
    }

    @Override
    public Vec sub(double x, double y, double z) {
        return new Vec(this.x - x, this.y - y, this.z - z);
    }

    @Override
    public Vec sub(Point point) {
        return this.sub(point.x(), point.y(), point.z());
    }

    @Override
    public Vec sub(double value) {
        return this.sub(value, value, value);
    }

    @Override
    public Vec mul(double x, double y, double z) {
        return new Vec(this.x * x, this.y * y, this.z * z);
    }

    @Override
    public Vec mul(Point point) {
        return this.mul(point.x(), point.y(), point.z());
    }

    @Override
    public Vec mul(double value) {
        return this.mul(value, value, value);
    }

    @Override
    public Vec div(double x, double y, double z) {
        return new Vec(this.x / x, this.y / y, this.z / z);
    }

    @Override
    public Vec div(Point point) {
        return this.div(point.x(), point.y(), point.z());
    }

    @Override
    public Vec div(double value) {
        return this.div(value, value, value);
    }

    @Override
    public Vec relative(BlockFace face) {
        Direction direction = face.toDirection();
        return this.add(direction.normalX(), direction.normalY(), direction.normalZ());
    }

    @Contract(pure=true)
    public Vec neg() {
        return new Vec(-this.x, -this.y, -this.z);
    }

    @Contract(pure=true)
    public Vec abs() {
        return new Vec(Math.abs(this.x), Math.abs(this.y), Math.abs(this.z));
    }

    @Contract(pure=true)
    public Vec min(Point point) {
        return new Vec(Math.min(this.x, point.x()), Math.min(this.y, point.y()), Math.min(this.z, point.z()));
    }

    @Contract(pure=true)
    public Vec min(double x, double y, double z) {
        return new Vec(Math.min(this.x, x), Math.min(this.y, y), Math.min(this.z, z));
    }

    @Contract(pure=true)
    public Vec min(double value) {
        return new Vec(Math.min(this.x, value), Math.min(this.y, value), Math.min(this.z, value));
    }

    @Contract(pure=true)
    public Vec max(Point point) {
        return new Vec(Math.max(this.x, point.x()), Math.max(this.y, point.y()), Math.max(this.z, point.z()));
    }

    @Contract(pure=true)
    public Vec max(double x, double y, double z) {
        return new Vec(Math.max(this.x, x), Math.max(this.y, y), Math.max(this.z, z));
    }

    @Contract(pure=true)
    public Vec max(double value) {
        return new Vec(Math.max(this.x, value), Math.max(this.y, value), Math.max(this.z, value));
    }

    @Deprecated
    @Contract(pure=true)
    public Pos asPosition() {
        return new Pos(this.x, this.y, this.z);
    }

    @Contract(pure=true)
    public double lengthSquared() {
        return MathUtils.square(this.x) + MathUtils.square(this.y) + MathUtils.square(this.z);
    }

    @Contract(pure=true)
    public double length() {
        return Math.sqrt(this.lengthSquared());
    }

    @Contract(pure=true)
    public Vec normalize() {
        double length = this.length();
        return new Vec(this.x / length, this.y / length, this.z / length);
    }

    public boolean isNormalized() {
        return Math.abs(this.lengthSquared() - 1.0) < 1.0E-6;
    }

    @Contract(pure=true)
    public double angle(Vec vec) {
        double dot = MathUtils.clamp(this.dot(vec) / (this.length() * vec.length()), -1.0, 1.0);
        return Math.acos(dot);
    }

    @Contract(pure=true)
    public double dot(Vec vec) {
        return this.x * vec.x + this.y * vec.y + this.z * vec.z;
    }

    @Contract(pure=true)
    public Vec cross(Vec o) {
        return new Vec(this.y * o.z - o.y * this.z, this.z * o.x - o.z * this.x, this.x * o.y - o.x * this.y);
    }

    @Contract(pure=true)
    public Vec rotateAroundX(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double newY = angleCos * this.y - angleSin * this.z;
        double newZ = angleSin * this.y + angleCos * this.z;
        return new Vec(this.x, newY, newZ);
    }

    @Contract(pure=true)
    public Vec rotateAroundY(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double newX = angleCos * this.x + angleSin * this.z;
        double newZ = -angleSin * this.x + angleCos * this.z;
        return new Vec(newX, this.y, newZ);
    }

    @Contract(pure=true)
    public Vec rotateAroundZ(double angle) {
        double angleCos = Math.cos(angle);
        double angleSin = Math.sin(angle);
        double newX = angleCos * this.x - angleSin * this.y;
        double newY = angleSin * this.x + angleCos * this.y;
        return new Vec(newX, newY, this.z);
    }

    @Contract(pure=true)
    public Vec rotate(double angleX, double angleY, double angleZ) {
        return this.rotateAroundX(angleX).rotateAroundY(angleY).rotateAroundZ(angleZ);
    }

    @Contract(pure=true)
    public Vec rotateFromView(float yawDegrees, float pitchDegrees) {
        double yaw = Math.toRadians(-1.0f * (yawDegrees + 90.0f));
        double pitch = Math.toRadians(-pitchDegrees);
        double cosYaw = Math.cos(yaw);
        double cosPitch = Math.cos(pitch);
        double sinYaw = Math.sin(yaw);
        double sinPitch = Math.sin(pitch);
        double initialX = this.x();
        double initialY = this.y();
        double x = initialX * cosPitch - initialY * sinPitch;
        double y = initialX * sinPitch + initialY * cosPitch;
        double initialZ = this.z();
        initialX = x;
        double z = initialZ * cosYaw - initialX * sinYaw;
        x = initialZ * sinYaw + initialX * cosYaw;
        return new Vec(x, y, z);
    }

    @Contract(pure=true)
    public Vec rotateFromView(Pos pos) {
        return this.rotateFromView(pos.yaw(), pos.pitch());
    }

    @Contract(pure=true)
    public Vec rotateAroundAxis(Vec axis, double angle) throws IllegalArgumentException {
        return this.rotateAroundNonUnitAxis(axis.isNormalized() ? axis : axis.normalize(), angle);
    }

    @Contract(pure=true)
    public Vec rotateAroundNonUnitAxis(Vec axis, double angle) throws IllegalArgumentException {
        double x = this.x();
        double y = this.y();
        double z = this.z();
        double x2 = axis.x();
        double y2 = axis.y();
        double z2 = axis.z();
        double cosTheta = Math.cos(angle);
        double sinTheta = Math.sin(angle);
        double dotProduct = this.dot(axis);
        double newX = x2 * dotProduct * (1.0 - cosTheta) + x * cosTheta + (-z2 * y + y2 * z) * sinTheta;
        double newY = y2 * dotProduct * (1.0 - cosTheta) + y * cosTheta + (z2 * x - x2 * z) * sinTheta;
        double newZ = z2 * dotProduct * (1.0 - cosTheta) + z * cosTheta + (-y2 * x + x2 * y) * sinTheta;
        return new Vec(newX, newY, newZ);
    }

    @Contract(pure=true)
    public Vec lerp(Vec vec, double alpha) {
        return new Vec(this.x + alpha * (vec.x - this.x), this.y + alpha * (vec.y - this.y), this.z + alpha * (vec.z - this.z));
    }

    @Contract(pure=true)
    public Vec interpolate(Vec target, double alpha, Interpolation interpolation) {
        return this.lerp(target, interpolation.apply(alpha));
    }

    @FunctionalInterface
    public static interface Operator {
        public static final Operator EPSILON = Operator.operator(v -> Math.abs(v) < 1.0E-6 ? 0.0 : v);
        public static final Operator FLOOR = Operator.operator(Math::floor);
        public static final Operator SIGNUM = Operator.operator(Math::signum);
        public static final Operator ABS = Operator.operator(Math::abs);
        public static final Operator NEG = Operator.operator(v -> -v);
        public static final Operator CEIL = Operator.operator(Math::ceil);

        public static Operator operator(DoubleUnaryOperator operator) {
            return (x, y, z) -> new Vec(operator.applyAsDouble(x), operator.applyAsDouble(y), operator.applyAsDouble(z));
        }

        public Vec apply(double var1, double var3, double var5);
    }

    @FunctionalInterface
    public static interface Interpolation {
        public static final Interpolation LINEAR = a -> a;
        public static final Interpolation SMOOTH = a -> a * a * (3.0 - 2.0 * a);

        public double apply(double var1);
    }
}

