/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.minestom.server.codec.Codec;
import net.minestom.server.entity.EntityTypeImpl;
import net.minestom.server.entity.EntityTypes;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public sealed interface EntityType
extends StaticProtocolObject<EntityType>,
EntityTypes
permits EntityTypeImpl {
    public static final NetworkBuffer.Type<EntityType> NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(EntityType::fromId, EntityType::id);
    public static final Codec<EntityType> CODEC = Codec.INT.transform(EntityType::fromId, EntityType::id);

    @Override
    @Contract(pure=true)
    public RegistryData.EntityEntry registry();

    @Override
    default public Key key() {
        return this.registry().key();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    default public double width() {
        return this.registry().width();
    }

    default public double height() {
        return this.registry().height();
    }

    public static Collection<EntityType> values() {
        return EntityTypeImpl.REGISTRY.values();
    }

    @Nullable
    public static EntityType fromKey(@KeyPattern String key) {
        return EntityType.fromKey(Key.key(key));
    }

    @Nullable
    public static EntityType fromKey(Key key) {
        return EntityTypeImpl.REGISTRY.get(key);
    }

    @Nullable
    public static EntityType fromId(int id) {
        return EntityTypeImpl.REGISTRY.get(id);
    }

    public static Registry<EntityType> staticRegistry() {
        return EntityTypeImpl.REGISTRY;
    }
}

