/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.utils.mojang.MojangUtils;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Nullable;

public record PlayerSkin(String textures, String signature) {
    @Blocking
    @Nullable
    public static PlayerSkin fromUuid(String uuid) {
        JsonObject jsonObject = MojangUtils.fromUuid(uuid);
        if (jsonObject == null) {
            return null;
        }
        try {
            JsonArray propertiesArray = jsonObject.get("properties").getAsJsonArray();
            for (JsonElement jsonElement : propertiesArray) {
                JsonObject propertyObject = jsonElement.getAsJsonObject();
                String name = propertyObject.get("name").getAsString();
                if (!name.equals("textures")) continue;
                String textureValue = propertyObject.get("value").getAsString();
                String signatureValue = propertyObject.get("signature").getAsString();
                return new PlayerSkin(textureValue, signatureValue);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Blocking
    @Nullable
    public static PlayerSkin fromUsername(String username) {
        JsonObject jsonObject = MojangUtils.fromUsername(username);
        if (jsonObject == null) {
            return null;
        }
        try {
            String uuid = jsonObject.get("id").getAsString();
            return PlayerSkin.fromUuid(uuid);
        }
        catch (Exception e) {
            return null;
        }
    }

    public record Patch(@Nullable Key body, @Nullable Key cape, @Nullable Key elytra, @Nullable Boolean slim) {
        public static final Patch EMPTY = new Patch(null, null, null, null);
        public static final NetworkBuffer.Type<Patch> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.KEY.optional(), Patch::body, NetworkBuffer.KEY.optional(), Patch::cape, NetworkBuffer.KEY.optional(), Patch::elytra, NetworkBuffer.BOOLEAN.optional(), Patch::slim, Patch::new);
        public static final StructCodec<Patch> CODEC = StructCodec.struct("body", Codec.KEY.optional(), Patch::body, "cape", Codec.KEY.optional(), Patch::cape, "elytra", Codec.KEY.optional(), Patch::elytra, "slim", Codec.BOOLEAN.optional(), Patch::slim, Patch::new);

        public Patch(Key body) {
            this(body, null, null, null);
        }
    }
}

