/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.damage;

import net.kyori.adventure.text.Component;
import net.minestom.server.MinecraftServer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.damage.DamageType;
import net.minestom.server.entity.damage.EntityDamage;
import net.minestom.server.entity.damage.EntityProjectileDamage;
import net.minestom.server.entity.damage.PositionalDamage;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Nullable;

public class Damage
implements Taggable {
    private static final DynamicRegistry<DamageType> DAMAGE_TYPE_REGISTRY = MinecraftServer.getDamageTypeRegistry();
    private final RegistryKey<DamageType> typeKey;
    private final DamageType type;
    private final Entity source;
    private final Entity attacker;
    private final Point sourcePosition;
    private final TagHandler tagHandler = TagHandler.newHandler();
    private float amount;

    public Damage(RegistryKey<DamageType> type, @Nullable Entity source, @Nullable Entity attacker, @Nullable Point sourcePosition, float amount) {
        this.typeKey = type;
        this.type = DAMAGE_TYPE_REGISTRY.get(type);
        Check.argCondition(this.type == null, "Damage type is not registered: {0}", type);
        this.source = source;
        this.attacker = attacker;
        this.sourcePosition = sourcePosition;
        this.amount = amount;
    }

    public RegistryKey<DamageType> getType() {
        return this.typeKey;
    }

    public int getTypeId() {
        return DAMAGE_TYPE_REGISTRY.getId(this.typeKey);
    }

    @Nullable
    public Entity getAttacker() {
        return this.attacker;
    }

    @Nullable
    public Entity getSource() {
        return this.source;
    }

    @Nullable
    public Point getSourcePosition() {
        return this.sourcePosition;
    }

    @Nullable
    public Component buildDeathMessage(Player killed) {
        return Component.translatable("death.attack." + this.type.messageId(), Component.text(killed.getUsername()));
    }

    public static Damage fromProjectile(@Nullable Entity shooter, Entity projectile, float amount) {
        return new EntityProjectileDamage(shooter, projectile, amount);
    }

    public static EntityDamage fromPlayer(Player player, float amount) {
        return new EntityDamage(player, amount);
    }

    public static EntityDamage fromEntity(Entity entity, float amount) {
        return new EntityDamage(entity, amount);
    }

    public static PositionalDamage fromPosition(RegistryKey<DamageType> type, Point sourcePosition, float amount) {
        return new PositionalDamage(type, sourcePosition, amount);
    }

    @Nullable
    public Component buildDeathScreenText(Player killed) {
        return Component.translatable("death.attack." + this.type.messageId());
    }

    @Nullable
    public SoundEvent getSound(LivingEntity entity) {
        if (entity instanceof Player) {
            return this.getPlayerSound((Player)entity);
        }
        return this.getGenericSound(entity);
    }

    protected SoundEvent getGenericSound(LivingEntity entity) {
        return SoundEvent.ENTITY_GENERIC_HURT;
    }

    protected SoundEvent getPlayerSound(Player player) {
        if (DamageType.ON_FIRE.equals(this.typeKey)) {
            return SoundEvent.ENTITY_PLAYER_HURT_ON_FIRE;
        }
        return SoundEvent.ENTITY_PLAYER_HURT;
    }

    @Override
    public TagHandler tagHandler() {
        return this.tagHandler;
    }

    public float getAmount() {
        return this.amount;
    }

    public void setAmount(float amount) {
        this.amount = amount;
    }
}

