/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.animal.CowVariantImpl;
import net.minestom.server.entity.metadata.animal.CowVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import org.jetbrains.annotations.ApiStatus;

public sealed interface CowVariant
extends CowVariants
permits CowVariantImpl {
    public static final Codec<CowVariant> REGISTRY_CODEC = StructCodec.struct("model", Model.CODEC.optional(Model.NORMAL), CowVariant::model, "asset_id", Codec.KEY, CowVariant::assetId, CowVariantImpl::new);
    public static final NetworkBuffer.Type<RegistryKey<CowVariant>> NETWORK_TYPE = RegistryKey.networkType(Registries::cowVariant);
    public static final Codec<RegistryKey<CowVariant>> CODEC = RegistryKey.codec(Registries::cowVariant);

    public static CowVariant create(Model model, Key assetId) {
        return new CowVariantImpl(model, assetId);
    }

    @ApiStatus.Internal
    public static DynamicRegistry<CowVariant> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("cow_variant"), REGISTRY_CODEC, RegistryData.Resource.COW_VARIANTS);
    }

    public Model model();

    public Key assetId();

    public static enum Model {
        NORMAL,
        COLD,
        WARM;

        public static final Codec<Model> CODEC;

        static {
            CODEC = Codec.Enum(Model.class);
        }
    }
}

