/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal;

import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.animal.AbstractHorseMeta;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.Nullable;

public class HorseMeta
extends AbstractHorseMeta {
    public HorseMeta(Entity entity, MetadataHolder metadata) {
        super(entity, metadata);
    }

    @Deprecated
    public Variant getVariant() {
        return HorseMeta.getVariantFromID(this.metadata.get(MetadataDef.Horse.VARIANT));
    }

    @Deprecated
    public void setVariant(Variant variant) {
        this.metadata.set(MetadataDef.Horse.VARIANT, HorseMeta.getVariantID(variant.marking, variant.color));
    }

    public static int getVariantID(Marking marking, Color color) {
        return (marking.ordinal() << 8) + color.ordinal();
    }

    public static Variant getVariantFromID(int variantID) {
        return new Variant(Marking.VALUES[variantID >> 8], Color.VALUES[variantID & 0xFF]);
    }

    @Override
    @Nullable
    protected <T> T get(DataComponent<T> component) {
        if (component == DataComponents.HORSE_VARIANT) {
            return (T)((Object)this.getVariant().getMarking());
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(DataComponent<T> component, T value) {
        if (component == DataComponents.HORSE_VARIANT) {
            Variant variant = this.getVariant();
            variant.setMarking((Marking)((Object)value));
            this.setVariant(variant);
        } else {
            super.set(component, value);
        }
    }

    public static class Variant {
        private Marking marking;
        private Color color;

        public Variant(Marking marking, Color color) {
            this.marking = marking;
            this.color = color;
        }

        public Marking getMarking() {
            return this.marking;
        }

        public void setMarking(Marking marking) {
            this.marking = marking;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }
    }

    public static enum Marking {
        NONE,
        WHITE,
        WHITE_FIELD,
        WHITE_DOTS,
        BLACK_DOTS;

        private static final Marking[] VALUES;

        static {
            VALUES = Marking.values();
        }
    }

    public static enum Color {
        WHITE,
        CREAMY,
        CHESTNUT,
        BROWN,
        BLACK,
        GRAY,
        DARK_BROWN;

        public static final NetworkBuffer.Type<Color> NETWORK_TYPE;
        public static final Codec<Color> NBT_TYPE;
        private static final Color[] VALUES;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Color.class);
            NBT_TYPE = Codec.Enum(Color.class);
            VALUES = Color.values();
        }
    }
}

