/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.animal.tameable;

import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariantImpl;
import net.minestom.server.entity.metadata.animal.tameable.WolfVariants;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.ApiStatus;

public sealed interface WolfVariant
extends WolfVariants
permits WolfVariantImpl {
    public static final Codec<WolfVariant> REGISTRY_CODEC = StructCodec.struct("assets", Assets.CODEC, WolfVariant::assets, WolfVariantImpl::new);
    public static final NetworkBuffer.Type<RegistryKey<WolfVariant>> NETWORK_TYPE = RegistryKey.networkType(Registries::wolfVariant);
    public static final Codec<RegistryKey<WolfVariant>> CODEC = RegistryKey.codec(Registries::wolfVariant);

    public static WolfVariant create(Assets assets) {
        return new WolfVariantImpl(assets);
    }

    public static WolfVariant create(Key wild, Key tame, Key angry) {
        return new WolfVariantImpl(new Assets(wild, tame, angry));
    }

    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<WolfVariant> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("wolf_variant"), REGISTRY_CODEC, RegistryData.Resource.WOLF_VARIANTS);
    }

    public Assets assets();

    public record Assets(Key wild, Key tame, Key angry) {
        public static final Codec<Assets> CODEC = StructCodec.struct("wild", Codec.KEY, Assets::wild, "tame", Codec.KEY, Assets::tame, "angry", Codec.KEY, Assets::angry, Assets::new);

        public Assets {
            Check.notNull(wild, "missing wild asset");
            Check.notNull(tame, "missing tame asset");
            Check.notNull(angry, "missing angry asset");
        }
    }

    public static final class Builder {
        private Assets assets;
        private Key wildAsset;
        private Key tameAsset;
        private Key angryAsset;

        private Builder() {
        }

        public Builder wildAsset(Key wildAsset) {
            this.wildAsset = wildAsset;
            return this;
        }

        public Builder tameAsset(Key tameAsset) {
            this.tameAsset = tameAsset;
            return this;
        }

        public Builder angryAsset(Key angryAsset) {
            this.angryAsset = angryAsset;
            return this;
        }

        public Builder assets(Assets assets) {
            this.assets = assets;
            return this;
        }

        public WolfVariant build() {
            Assets assets = Objects.requireNonNullElseGet(this.assets, () -> new Assets(this.wildAsset, this.tameAsset, this.angryAsset));
            return new WolfVariantImpl(assets);
        }
    }
}

