/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.golem;

import net.minestom.server.codec.Codec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.golem.AbstractGolemMeta;
import net.minestom.server.network.NetworkBuffer;
import org.jetbrains.annotations.NotNull;

public class CopperGolemMeta
extends AbstractGolemMeta {
    public CopperGolemMeta(@NotNull Entity entity, @NotNull MetadataHolder metadata) {
        super(entity, metadata);
    }

    @NotNull
    public WeatherState getWeatherState() {
        return this.metadata.get(MetadataDef.CopperGolem.WEATHER_STATE);
    }

    public void setWeatherState(@NotNull WeatherState weatherState) {
        this.metadata.set(MetadataDef.CopperGolem.WEATHER_STATE, weatherState);
    }

    @NotNull
    public State getState() {
        return this.metadata.get(MetadataDef.CopperGolem.STATE);
    }

    public void setState(@NotNull State state) {
        this.metadata.set(MetadataDef.CopperGolem.STATE, state);
    }

    public static enum WeatherState {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

        public static final NetworkBuffer.Type<WeatherState> NETWORK_TYPE;
        public static final Codec<WeatherState> CODEC;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(WeatherState.class);
            CODEC = Codec.Enum(WeatherState.class);
        }
    }

    public static enum State {
        IDLE,
        GETTING_ITEM,
        GETTING_NO_ITEM,
        DROPPING_ITEM,
        DROPPING_NO_ITEM;

        public static final NetworkBuffer.Type<State> NETWORK_TYPE;
        public static final Codec<State> CODEC;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(State.class);
            CODEC = Codec.Enum(State.class);
        }
    }
}

