/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.monster.zombie;

import net.minestom.server.collision.BoundingBox;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.monster.MonsterMeta;

public class ZombieMeta
extends MonsterMeta {
    public ZombieMeta(Entity entity, MetadataHolder metadata) {
        super(entity, metadata);
    }

    public boolean isBaby() {
        return this.metadata.get(MetadataDef.Zombie.IS_BABY);
    }

    public void setBaby(boolean value) {
        if (this.isBaby() == value) {
            return;
        }
        this.consumeEntity(entity -> {
            BoundingBox bb = entity.getBoundingBox();
            if (value) {
                double width = bb.width() / 2.0;
                entity.setBoundingBox(width, bb.height() / 2.0, width);
            } else {
                double width = bb.width() * 2.0;
                entity.setBoundingBox(width, bb.height() * 2.0, width);
            }
        });
        this.metadata.set(MetadataDef.Zombie.IS_BABY, value);
    }

    public boolean isBecomingDrowned() {
        return this.metadata.get(MetadataDef.Zombie.IS_BECOMING_DROWNED);
    }

    public void setBecomingDrowned(boolean value) {
        this.metadata.set(MetadataDef.Zombie.IS_BECOMING_DROWNED, value);
    }
}

