/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.villager;

import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponents;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.VillagerProfession;
import net.minestom.server.entity.VillagerType;
import net.minestom.server.entity.metadata.villager.AbstractVillagerMeta;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.Nullable;

public class VillagerMeta
extends AbstractVillagerMeta {
    public VillagerMeta(Entity entity, MetadataHolder metadata) {
        super(entity, metadata);
    }

    public VillagerData getVillagerData() {
        return this.metadata.get(MetadataDef.Villager.VARIANT);
    }

    public void setVillagerData(VillagerData data) {
        this.metadata.set(MetadataDef.Villager.VARIANT, data);
    }

    @Override
    @Nullable
    protected <T> T get(DataComponent<T> component) {
        if (component == DataComponents.VILLAGER_VARIANT) {
            return (T)this.getVillagerData().type();
        }
        return super.get(component);
    }

    @Override
    protected <T> void set(DataComponent<T> component, T value) {
        if (component == DataComponents.VILLAGER_VARIANT) {
            this.setVillagerData(this.getVillagerData().withType((VillagerType)value));
        } else {
            super.set(component, value);
        }
    }

    public record VillagerData(VillagerType type, VillagerProfession profession, Level level) {
        public static final VillagerData DEFAULT = new VillagerData(VillagerType.DESERT, VillagerProfession.NONE, Level.NOVICE);
        public static final NetworkBuffer.Type<VillagerData> NETWORK_TYPE = NetworkBufferTemplate.template(VillagerType.NETWORK_TYPE, VillagerData::type, VillagerProfession.NETWORK_TYPE, VillagerData::profession, Level.NETWORK_TYPE, VillagerData::level, VillagerData::new);

        public VillagerData withType(VillagerType type) {
            return new VillagerData(type, this.profession, this.level);
        }

        public VillagerData withProfession(VillagerProfession profession) {
            return new VillagerData(this.type, profession, this.level);
        }

        public VillagerData withLevel(Level level) {
            return new VillagerData(this.type, this.profession, level);
        }
    }

    public static enum Level {
        NOVICE,
        APPRENTICE,
        JOURNEYMAN,
        EXPERT,
        MASTER;

        public static final NetworkBuffer.Type<Level> NETWORK_TYPE;

        static {
            NETWORK_TYPE = NetworkBuffer.Enum(Level.class);
        }
    }
}

