/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.metadata.water.fish;

import net.minestom.server.entity.Entity;
import net.minestom.server.entity.MetadataDef;
import net.minestom.server.entity.MetadataHolder;
import net.minestom.server.entity.metadata.water.fish.AbstractFishMeta;

public class PufferfishMeta
extends AbstractFishMeta {
    public PufferfishMeta(Entity entity, MetadataHolder metadata) {
        super(entity, metadata);
        this.updateBoundingBox(State.UNPUFFED);
    }

    public State getState() {
        return State.VALUES[this.metadata.get(MetadataDef.PufferFish.PUFF_STATE)];
    }

    public void setState(State state) {
        this.metadata.set(MetadataDef.PufferFish.PUFF_STATE, state.ordinal());
        this.updateBoundingBox(state);
    }

    private void updateBoundingBox(State state) {
        this.consumeEntity(entity -> {
            switch (state.ordinal()) {
                case 0: {
                    entity.setBoundingBox(0.35, 0.35, 0.35);
                    break;
                }
                case 1: {
                    entity.setBoundingBox(0.5, 0.5, 0.5);
                    break;
                }
                default: {
                    entity.setBoundingBox(0.7, 0.7, 0.7);
                }
            }
        });
    }

    public static enum State {
        UNPUFFED,
        SEMI_PUFFED,
        FULLY_PUFFED;

        private static final State[] VALUES;

        static {
            VALUES = State.values();
        }
    }
}

