/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.followers;

import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Pos;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.LivingEntity;
import net.minestom.server.entity.attribute.Attribute;
import net.minestom.server.entity.pathfinding.followers.NodeFollower;
import net.minestom.server.instance.Instance;
import net.minestom.server.utils.position.PositionUtils;
import org.jetbrains.annotations.Nullable;

public class WaterNodeFollower
implements NodeFollower {
    private final Entity entity;
    private static final double WATER_SPEED_MULTIPLIER = 0.5;

    public WaterNodeFollower(Entity entity) {
        this.entity = entity;
    }

    @Override
    public void moveTowards(Point direction, double speed, Point lookAt) {
        Instance instance;
        Pos position = this.entity.getPosition();
        double dx = direction.x() - position.x();
        double dy = direction.y() - position.y();
        double dz = direction.z() - position.z();
        double dxLook = lookAt.x() - position.x();
        double dyLook = lookAt.y() - position.y();
        double dzLook = lookAt.z() - position.z();
        double distSquared = dx * dx + dy * dy + dz * dz;
        if (speed > distSquared) {
            speed = distSquared;
        }
        if ((instance = this.entity.getInstance()) != null && instance.getBlock(position).isLiquid()) {
            speed *= 0.5;
        }
        double radians = Math.atan2(dz, dx);
        double speedX = Math.cos(radians) * speed;
        double speedZ = Math.sin(radians) * speed;
        float yaw = PositionUtils.getLookYaw(dxLook, dzLook);
        float pitch = PositionUtils.getLookPitch(dxLook, dyLook, dzLook);
        double speedY = Math.signum(dy) * 0.5 * speed;
        if (Math.min(Math.abs(dy), Math.abs(speedY)) == Math.abs(dy)) {
            speedY = dy;
        }
        PhysicsResult physicsResult = CollisionUtils.handlePhysics(this.entity, new Vec(speedX, speedY, speedZ));
        this.entity.refreshPosition(physicsResult.newPosition().asPos().withView(yaw, pitch));
    }

    @Override
    public void jump(@Nullable Point point, @Nullable Point target) {
    }

    @Override
    public boolean isAtPoint(Point point) {
        return this.entity.getPosition().sameBlock(point);
    }

    @Override
    public double movementSpeed() {
        Entity entity = this.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.getAttribute(Attribute.MOVEMENT_SPEED).getValue();
        }
        return 0.1f;
    }
}

