/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.generators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.OptionalDouble;
import java.util.Set;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.entity.pathfinding.PNode;
import net.minestom.server.entity.pathfinding.generators.NodeGenerator;
import net.minestom.server.instance.block.Block;

public class FlyingNodeGenerator
implements NodeGenerator {
    private PNode tempNode = null;

    @Override
    public Collection<? extends PNode> getWalkable(Block.Getter getter, Set<PNode> visited, PNode current, Point goal, BoundingBox boundingBox) {
        double downPointZ;
        double downPointY;
        double downPointX;
        PNode nodeFall;
        double upPointZ;
        double upPointY;
        ArrayList<PNode> nearby = new ArrayList<PNode>();
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, current);
        int stepSize = (int)Math.max(Math.floor(boundingBox.width() / 2.0), 1.0);
        if (stepSize < 1) {
            stepSize = 1;
        }
        for (int x = -stepSize; x <= stepSize; ++x) {
            for (int z = -stepSize; z <= stepSize; ++z) {
                PNode nodeFall2;
                PNode nodeJump;
                if (x == 0 && z == 0) continue;
                double cost = Math.sqrt(x * x + z * z) * 0.98;
                double currentLevelPointX = (double)current.blockX() + 0.5 + (double)x;
                double currentLevelPointY = (double)current.blockY() + 0.5;
                double currentLevelPointZ = (double)current.blockZ() + 0.5 + (double)z;
                double upPointX = (double)current.blockX() + 0.5 + (double)x;
                double upPointY2 = (double)(current.blockY() + 1) + 0.5;
                double upPointZ2 = (double)current.blockZ() + 0.5 + (double)z;
                double downPointX2 = (double)current.blockX() + 0.5 + (double)x;
                double downPointY2 = (double)(current.blockY() - 1) + 0.5;
                double downPointZ2 = (double)current.blockZ() + 0.5 + (double)z;
                PNode nodeWalk = this.createFly(getter, new Vec(currentLevelPointX, currentLevelPointY, currentLevelPointZ), boundingBox, cost, current, goal, visited);
                if (nodeWalk != null && !visited.contains(nodeWalk)) {
                    nearby.add(nodeWalk);
                }
                if ((nodeJump = this.createFly(getter, new Vec(upPointX, upPointY2, upPointZ2), boundingBox, cost, current, goal, visited)) != null && !visited.contains(nodeJump)) {
                    nearby.add(nodeJump);
                }
                if ((nodeFall2 = this.createFly(getter, new Vec(downPointX2, downPointY2, downPointZ2), boundingBox, cost, current, goal, visited)) == null || visited.contains(nodeFall2)) continue;
                nearby.add(nodeFall2);
            }
        }
        double upPointX = current.x();
        PNode nodeJump = this.createFly(getter, new Vec(upPointX, upPointY = (double)(current.blockY() + 1) + 0.5, upPointZ = current.z()), boundingBox, 2.0, current, goal, visited);
        if (nodeJump != null && !visited.contains(nodeJump)) {
            nearby.add(nodeJump);
        }
        if ((nodeFall = this.createFly(getter, new Vec(downPointX = current.x(), downPointY = (double)(current.blockY() - 1) + 0.5, downPointZ = current.z()), boundingBox, 2.0, current, goal, visited)) != null && !visited.contains(nodeFall)) {
            nearby.add(nodeFall);
        }
        return nearby;
    }

    @Override
    public boolean hasGravitySnap() {
        return false;
    }

    private PNode createFly(Block.Getter getter, Point point, BoundingBox boundingBox, double cost, PNode start, Point goal, Set<PNode> closed) {
        PNode n = this.newNode(start, cost, point, goal);
        if (closed.contains(n)) {
            return null;
        }
        if (!this.canMoveTowards(getter, new Vec(start.x(), start.y(), start.z()), point, boundingBox)) {
            return null;
        }
        n.setType(PNode.Type.FLY);
        return n;
    }

    private PNode newNode(PNode current, double cost, Point point, Point goal) {
        this.tempNode.setG(current.g() + cost);
        this.tempNode.setH(this.heuristic(point, goal));
        this.tempNode.setPoint(point.x(), point.y(), point.z());
        PNode newNode = this.tempNode;
        this.tempNode = new PNode(0.0, 0.0, 0.0, 0.0, 0.0, PNode.Type.WALK, current);
        return newNode;
    }

    @Override
    public OptionalDouble gravitySnap(Block.Getter getter, double pointX, double pointY, double pointZ, BoundingBox boundingBox, double maxFall) {
        return OptionalDouble.of(pointY);
    }
}

