/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.entity.pathfinding.generators;

import java.util.Collection;
import java.util.OptionalDouble;
import java.util.Set;
import net.minestom.server.collision.BoundingBox;
import net.minestom.server.collision.CollisionUtils;
import net.minestom.server.collision.PhysicsResult;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.pathfinding.PNode;
import net.minestom.server.instance.block.Block;

public interface NodeGenerator {
    public Collection<? extends PNode> getWalkable(Block.Getter var1, Set<PNode> var2, PNode var3, Point var4, BoundingBox var5);

    public boolean hasGravitySnap();

    public OptionalDouble gravitySnap(Block.Getter var1, double var2, double var4, double var6, BoundingBox var8, double var9);

    default public boolean canMoveTowards(Block.Getter getter, Point start, Point end, BoundingBox boundingBox) {
        Point diff = end.sub(start);
        if (getter.getBlock(end) != Block.AIR) {
            return false;
        }
        PhysicsResult res = CollisionUtils.handlePhysics(getter, boundingBox, start.asPos(), diff.asVec(), null, false);
        return !res.collisionZ() && !res.collisionY() && !res.collisionX();
    }

    default public boolean pointInvalid(Block.Getter getter, Point point, BoundingBox boundingBox) {
        BoundingBox.PointIterator iterator = boundingBox.getBlocks(point);
        while (iterator.hasNext()) {
            BoundingBox.MutablePoint block = iterator.next();
            if (!getter.getBlock(block.blockX(), block.blockY(), block.blockZ(), Block.Getter.Condition.TYPE).isSolid()) continue;
            return true;
        }
        return false;
    }

    default public double heuristic(Point node, Point target) {
        return node.distance(target);
    }
}

