/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventFilter;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public interface EventBinding<E extends Event> {
    public static <E extends Event, T> FilteredBuilder<E, T> filtered(EventFilter<E, T> filter, Predicate<T> predicate) {
        return new FilteredBuilder<E, T>(filter, predicate);
    }

    public Collection<Class<? extends Event>> eventTypes();

    public Consumer<E> consumer(Class<? extends Event> var1);

    public static class FilteredBuilder<E extends Event, T> {
        private final EventFilter<E, T> filter;
        private final Predicate<T> predicate;
        private final Map<Class<? extends Event>, BiConsumer<Object, E>> mapped = new HashMap<Class<? extends Event>, BiConsumer<Object, E>>();

        FilteredBuilder(EventFilter<E, T> filter, Predicate<T> predicate) {
            this.filter = filter;
            this.predicate = predicate;
        }

        public <M extends E> FilteredBuilder<E, T> map(Class<M> eventType, BiConsumer<T, M> consumer) {
            this.mapped.put(eventType, consumer);
            return this;
        }

        public EventBinding<E> build() {
            Map<Class<Event>, BiConsumer<Object, E>> copy = Map.copyOf(this.mapped);
            final Set<Class<? extends Event>> eventTypes = copy.keySet();
            final HashMap<Class<? extends Event>, Consumer<Event>> consumers = new HashMap<Class<? extends Event>, Consumer<Event>>(eventTypes.size());
            for (Class<? extends Event> eventType : eventTypes) {
                BiConsumer<Object, E> consumer = copy.get(eventType);
                consumers.put(eventType, event -> {
                    T handler = this.filter.getHandler((Event)event);
                    if (!this.predicate.test(handler)) {
                        return;
                    }
                    consumer.accept(handler, event);
                });
            }
            return new EventBinding<E>(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public Collection<Class<? extends Event>> eventTypes() {
                    return eventTypes;
                }

                @Override
                public Consumer<E> consumer(Class<? extends Event> eventType) {
                    return (Consumer)consumers.get(eventType);
                }
            };
        }
    }
}

