/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minestom.server.event.Event;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.event.trait.RecursiveEvent;
import org.jetbrains.annotations.Contract;

public interface EventListener<T extends Event> {
    public Class<T> eventType();

    public Result run(T var1);

    @Contract(pure=true)
    public static <T extends Event> Builder<T> builder(Class<T> eventType) {
        return new Builder<T>(eventType);
    }

    @Contract(pure=true)
    public static <T extends Event> EventListener<T> of(Class<T> eventType, Consumer<T> listener) {
        if (CancellableEvent.class.isAssignableFrom(eventType) || RecursiveEvent.class.isAssignableFrom(eventType)) {
            return new Builder.ListenerImpl<Event>(eventType, event -> {
                CancellableEvent cancellableEvent;
                if (event instanceof CancellableEvent && (cancellableEvent = (CancellableEvent)event).isCancelled()) {
                    return Result.INVALID;
                }
                listener.accept(event);
                return Result.SUCCESS;
            });
        }
        return new Builder.ListenerImpl<Event>(eventType, event -> {
            listener.accept(event);
            return Result.SUCCESS;
        });
    }

    public static class Builder<T extends Event> {
        private final Class<T> eventType;
        private final List<Predicate<T>> filters = new ArrayList<Predicate<T>>();
        private boolean ignoreCancelled = true;
        private int expireCount;
        private Predicate<T> expireWhen;
        private Consumer<T> handler;

        protected Builder(Class<T> eventType) {
            this.eventType = eventType;
        }

        @Contract(value="_ -> this")
        public Builder<T> filter(Predicate<T> filter) {
            this.filters.add(filter);
            return this;
        }

        @Contract(value="_ -> this")
        public Builder<T> ignoreCancelled(boolean ignoreCancelled) {
            this.ignoreCancelled = ignoreCancelled;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder<T> expireCount(int expireCount) {
            this.expireCount = expireCount;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder<T> expireWhen(Predicate<T> expireWhen) {
            this.expireWhen = expireWhen;
            return this;
        }

        @Contract(value="_ -> this")
        public Builder<T> handler(Consumer<T> handler) {
            this.handler = handler;
            return this;
        }

        @Contract(value="-> new", pure=true)
        public EventListener<T> build() {
            boolean ignoreCancelled = this.ignoreCancelled;
            AtomicInteger expirationCount = new AtomicInteger(this.expireCount);
            boolean hasExpirationCount = expirationCount.get() > 0;
            Predicate expireWhen = this.expireWhen;
            ArrayList filters = new ArrayList(this.filters);
            Consumer handler = this.handler;
            return new ListenerImpl<Event>(this.eventType, event -> {
                CancellableEvent cancellableEvent;
                if (ignoreCancelled && event instanceof CancellableEvent && (cancellableEvent = (CancellableEvent)event).isCancelled()) {
                    return Result.INVALID;
                }
                if (expireWhen != null && expireWhen.test(event)) {
                    return Result.EXPIRED;
                }
                if (!filters.isEmpty()) {
                    for (Predicate filter : filters) {
                        if (filter.test(event)) continue;
                        return Result.INVALID;
                    }
                }
                if (handler != null) {
                    handler.accept(event);
                }
                if (hasExpirationCount && expirationCount.decrementAndGet() == 0) {
                    return Result.EXPIRED;
                }
                return Result.SUCCESS;
            });
        }

        private record ListenerImpl<T extends Event>(Class<T> eventType, Function<T, Result> function) implements EventListener<T>
        {
            @Override
            public Result run(T t) {
                return this.function.apply(t);
            }
        }
    }

    public static enum Result {
        SUCCESS,
        INVALID,
        EXPIRED,
        EXCEPTION;

    }
}

