/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.event;

import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minestom.server.event.Event;
import net.minestom.server.event.EventBinding;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventListener;
import net.minestom.server.event.EventNodeImpl;
import net.minestom.server.event.ListenerHandle;
import net.minestom.server.event.trait.CancellableEvent;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public sealed interface EventNode<T extends Event>
permits EventNodeImpl {
    @Contract(value="_ -> new", pure=true)
    public static EventNode<Event> all(String name) {
        return EventNode.type(name, EventFilter.ALL);
    }

    @Contract(value="_, _ -> new", pure=true)
    public static <E extends Event, V> EventNode<E> type(String name, EventFilter<E, V> filter) {
        return EventNode.create(name, filter, null);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <E extends Event, V> EventNode<E> event(String name, EventFilter<E, V> filter, Predicate<E> predicate) {
        return EventNode.create(name, filter, (e, h) -> predicate.test(e));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <E extends Event, V> EventNode<E> type(String name, EventFilter<E, V> filter, BiPredicate<E, V> predicate) {
        return EventNode.create(name, filter, predicate);
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <E extends Event, V> EventNode<E> value(String name, EventFilter<E, V> filter, Predicate<V> predicate) {
        return EventNode.create(name, filter, (e, h) -> predicate.test(h));
    }

    @Contract(value="_, _, _ -> new", pure=true)
    public static <E extends Event> EventNode<E> tag(String name, EventFilter<E, ? extends TagReadable> filter, Tag<?> tag) {
        return EventNode.create(name, filter, (e, h) -> h.hasTag(tag));
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    public static <E extends Event, V> EventNode<E> tag(String name, EventFilter<E, ? extends TagReadable> filter, Tag<V> tag, Predicate<@Nullable V> consumer) {
        return EventNode.create(name, filter, (e, h) -> consumer.test(h.getTag(tag)));
    }

    private static <E extends Event, V> EventNode<E> create(String name, EventFilter<E, V> filter, @Nullable BiPredicate<E, V> predicate) {
        return new EventNodeImpl<Event>(name, filter, predicate != null ? (e, o) -> predicate.test(e, o) : null);
    }

    default public void call(T event) {
        this.getHandle(event.getClass()).call(event);
    }

    default public boolean hasListener(Class<? extends T> type) {
        return this.getHandle(type).hasListener();
    }

    @ApiStatus.Experimental
    public <E extends T> ListenerHandle<E> getHandle(Class<E> var1);

    default public void callCancellable(T event, Runnable successCallback) {
        CancellableEvent cancellableEvent;
        this.call(event);
        if (!(event instanceof CancellableEvent) || !(cancellableEvent = (CancellableEvent)event).isCancelled()) {
            successCallback.run();
        }
    }

    @Contract(pure=true)
    public Class<T> getEventType();

    @Contract(pure=true)
    public String getName();

    @Contract(pure=true)
    public int getPriority();

    @Contract(value="_ -> this")
    public EventNode<T> setPriority(int var1);

    @Contract(pure=true)
    @Nullable
    public EventNode<? super T> getParent();

    @Contract(pure=true)
    public Set<EventNode<T>> getChildren();

    @Contract(pure=true)
    public <E extends T> List<EventNode<E>> findChildren(String var1, Class<E> var2);

    @Contract(pure=true)
    default public List<EventNode<T>> findChildren(String name) {
        return this.findChildren(name, this.getEventType());
    }

    public <E extends T> void replaceChildren(String var1, Class<E> var2, EventNode<E> var3);

    default public void replaceChildren(String name, EventNode<T> eventNode) {
        this.replaceChildren(name, this.getEventType(), eventNode);
    }

    public void removeChildren(String var1, Class<? extends T> var2);

    default public void removeChildren(String name) {
        this.removeChildren(name, this.getEventType());
    }

    @Contract(value="_ -> this")
    public EventNode<T> addChild(EventNode<? extends T> var1);

    @Contract(value="_ -> this")
    public EventNode<T> removeChild(EventNode<? extends T> var1);

    @Contract(value="_ -> this")
    public EventNode<T> addListener(EventListener<? extends T> var1);

    @Contract(value="_, _ -> this")
    default public <E extends T> EventNode<T> addListener(Class<E> eventType, Consumer<E> listener) {
        return this.addListener(EventListener.of(eventType, listener));
    }

    @Contract(value="_ -> this")
    public EventNode<T> removeListener(EventListener<? extends T> var1);

    @ApiStatus.Experimental
    public <E extends T, H> EventNode<E> map(H var1, EventFilter<E, H> var2);

    @ApiStatus.Experimental
    public void unmap(Object var1);

    @ApiStatus.Experimental
    public void register(EventBinding<? extends T> var1);

    @ApiStatus.Experimental
    public void unregister(EventBinding<? extends T> var1);
}

