/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.lan;

import java.time.Duration;
import java.util.Objects;
import net.minestom.server.utils.time.TimeUnit;
import org.jetbrains.annotations.Contract;

public class OpenToLANConfig {
    int port = 0;
    Duration delayBetweenPings = Duration.of(1500L, TimeUnit.MILLISECOND);
    Duration delayBetweenEvent = Duration.of(30L, TimeUnit.SECOND);

    @Contract(value="_ -> this")
    public OpenToLANConfig port(int port) {
        this.port = port;
        return this;
    }

    @Contract(value="_ -> this")
    public OpenToLANConfig pingDelay(Duration delay) {
        this.delayBetweenPings = Objects.requireNonNull(delay, "delay");
        return this;
    }

    @Contract(value="_ -> this")
    public OpenToLANConfig eventCallDelay(Duration delay) {
        this.delayBetweenEvent = Objects.requireNonNull(delay, "delay");
        return this;
    }
}

