/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.query;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Random;
import net.minestom.server.MinecraftServer;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.extras.query.event.BasicQueryEvent;
import net.minestom.server.extras.query.event.FullQueryEvent;
import net.minestom.server.extras.query.event.QueryEvent;
import net.minestom.server.extras.query.response.BasicQueryResponse;
import net.minestom.server.extras.query.response.FullQueryResponse;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.timer.Task;
import net.minestom.server.utils.time.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    public static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    private static final Random RANDOM = new Random();
    private static final Int2ObjectMap<SocketAddress> CHALLENGE_TOKENS = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap());
    private static volatile boolean started;
    private static volatile DatagramSocket socket;
    private static volatile Thread thread;
    private static volatile Task task;

    private Query() {
    }

    public static int start() {
        if (socket != null) {
            throw new IllegalArgumentException("System is already running");
        }
        int port = 0;
        Query.start(port);
        return port;
    }

    public static boolean start(int port) {
        if (socket != null) {
            return false;
        }
        try {
            socket = new DatagramSocket(port);
        }
        catch (SocketException e) {
            LOGGER.warn("Could not open the query port!", e);
            return false;
        }
        thread = new Thread(Query::run);
        thread.start();
        started = true;
        task = MinecraftServer.getSchedulerManager().buildTask(CHALLENGE_TOKENS::clear).repeat(30L, TimeUnit.SECOND).schedule();
        return true;
    }

    public static boolean stop() {
        if (!started) {
            return false;
        }
        started = false;
        thread = null;
        socket.close();
        socket = null;
        task.cancel();
        CHALLENGE_TOKENS.clear();
        return true;
    }

    public static boolean isStarted() {
        return started;
    }

    private static void run() {
        byte[] buffer = new byte[16];
        while (started) {
            QueryEvent event;
            int challengeToken;
            int sessionID;
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                socket.receive(packet);
            }
            catch (IOException e) {
                if (!started) {
                    LOGGER.error("An error occurred whilst receiving a query packet.", e);
                    continue;
                }
                return;
            }
            ByteBuffer data = ByteBuffer.wrap(packet.getData());
            if ((data.getShort() & 0xFFFF) != 65277) continue;
            byte type = data.get();
            if (type == 9) {
                sessionID = data.getInt();
                challengeToken = RANDOM.nextInt();
                CHALLENGE_TOKENS.put(challengeToken, packet.getSocketAddress());
                byte[] responseData = NetworkBuffer.makeArray(response -> {
                    response.write(NetworkBuffer.BYTE, (byte)9);
                    response.write(NetworkBuffer.INT, sessionID);
                    response.write(NetworkBuffer.STRING_TERMINATED, String.valueOf(challengeToken));
                });
                try {
                    socket.send(new DatagramPacket(responseData, responseData.length, packet.getSocketAddress()));
                    continue;
                }
                catch (IOException e) {
                    if (!started) {
                        LOGGER.error("An error occurred whilst sending a query handshake packet.", e);
                        continue;
                    }
                    return;
                }
            }
            if (type != 0) continue;
            sessionID = data.getInt();
            challengeToken = data.getInt();
            SocketAddress sender = packet.getSocketAddress();
            if (!CHALLENGE_TOKENS.containsKey(challengeToken) || !((SocketAddress)CHALLENGE_TOKENS.get(challengeToken)).equals(sender)) continue;
            int remaining = data.remaining();
            if (remaining == 0) {
                event = new BasicQueryEvent(sender, sessionID);
                EventDispatcher.callCancellable(event, () -> Query.lambda$run$1((BasicQueryEvent)event, sessionID, sender));
                continue;
            }
            if (remaining != 5) continue;
            event = new FullQueryEvent(sender, sessionID);
            EventDispatcher.callCancellable(event, () -> Query.lambda$run$2((FullQueryEvent)event, sessionID, sender));
        }
    }

    private static <T> void sendResponse(NetworkBuffer.Type<T> type, T queryResponse, int sessionID, SocketAddress sender) {
        block2: {
            byte[] responseData = NetworkBuffer.makeArray(buffer -> {
                buffer.write(NetworkBuffer.BYTE, (byte)0);
                buffer.write(NetworkBuffer.INT, sessionID);
                buffer.write(type, queryResponse);
            });
            try {
                socket.send(new DatagramPacket(responseData, responseData.length, sender));
            }
            catch (IOException e) {
                if (started) break block2;
                LOGGER.error("An error occurred whilst sending a query handshake packet.", e);
            }
        }
    }

    private static /* synthetic */ void lambda$run$2(FullQueryEvent event, int sessionID, SocketAddress sender) {
        Query.sendResponse(FullQueryResponse.SERIALIZER, (FullQueryResponse)event.getQueryResponse(), sessionID, sender);
    }

    private static /* synthetic */ void lambda$run$1(BasicQueryEvent event, int sessionID, SocketAddress sender) {
        Query.sendResponse(BasicQueryResponse.SERIALIZER, (BasicQueryResponse)event.getQueryResponse(), sessionID, sender);
    }
}

