/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.extras.velocity;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import net.minestom.server.Auth;
import net.minestom.server.extras.MojangAuth;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.utils.validate.Check;

@Deprecated(forRemoval=true)
public final class VelocityProxy {
    public static final String PLAYER_INFO_CHANNEL = "velocity:player_info";
    private static final int SUPPORTED_FORWARDING_VERSION = 1;
    private static final String MAC_ALGORITHM = "HmacSHA256";
    private static volatile boolean enabled;
    private static Key key;

    public static void enable(String secret) {
        Check.stateCondition(enabled, "Velocity modern forwarding is already enabled");
        Check.stateCondition(MojangAuth.isEnabled(), "Velocity modern forwarding should not be enabled with MojangAuth");
        enabled = true;
        key = Auth.Velocity.secretKey(secret);
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static Key getKey() {
        return key;
    }

    public static boolean checkIntegrity(NetworkBuffer buffer) {
        byte[] signature = new byte[32];
        for (int i = 0; i < signature.length; ++i) {
            signature[i] = buffer.read(NetworkBuffer.BYTE);
        }
        long index = buffer.readIndex();
        byte[] data = buffer.read(NetworkBuffer.RAW_BYTES);
        buffer.readIndex(index);
        try {
            Mac mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(key);
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        int version = buffer.read(NetworkBuffer.VAR_INT);
        return version == 1;
    }
}

