/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.Collection;
import java.util.concurrent.Phaser;
import net.minestom.server.MinecraftServer;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.NoopChunkLoaderImpl;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public interface ChunkLoader {
    @Contract(pure=true)
    public static ChunkLoader noop() {
        return NoopChunkLoaderImpl.INSTANCE;
    }

    default public void loadInstance(Instance instance) {
    }

    @Nullable
    public Chunk loadChunk(Instance var1, int var2, int var3);

    default public void saveInstance(Instance instance) {
    }

    public void saveChunk(Chunk var1);

    default public void saveChunks(Collection<Chunk> chunks) {
        if (this.supportsParallelSaving()) {
            Phaser phaser = new Phaser(1);
            for (Chunk chunk : chunks) {
                phaser.register();
                Thread.startVirtualThread(() -> {
                    try {
                        this.saveChunk(chunk);
                        phaser.arriveAndDeregister();
                    }
                    catch (Throwable e) {
                        MinecraftServer.getExceptionManager().handleException(e);
                    }
                });
            }
            phaser.arriveAndAwaitAdvance();
        } else {
            for (Chunk chunk : chunks) {
                this.saveChunk(chunk);
            }
        }
    }

    default public boolean supportsParallelSaving() {
        return false;
    }

    default public boolean supportsParallelLoading() {
        return false;
    }

    default public void unloadChunk(Chunk chunk) {
    }
}

