/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minestom.server.Viewable;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.ExperienceOrb;
import net.minestom.server.entity.ItemEntity;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.EntityTrackerImpl;
import net.minestom.server.instance.SharedInstance;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public sealed interface EntityTracker
permits EntityTrackerImpl {
    public static EntityTracker newTracker() {
        return new EntityTrackerImpl();
    }

    public <T extends Entity> void register(Entity var1, Point var2, Target<T> var3, @Nullable Update<T> var4);

    public <T extends Entity> void unregister(Entity var1, Target<T> var2, @Nullable Update<T> var3);

    @Nullable
    public Entity getEntityById(int var1);

    @Nullable
    public Entity getEntityByUuid(UUID var1);

    public <T extends Entity> void move(Entity var1, Point var2, Target<T> var3, @Nullable Update<T> var4);

    public <T extends Entity> @UnmodifiableView Collection<T> chunkEntities(int var1, int var2, Target<T> var3);

    default public <T extends Entity> @UnmodifiableView Collection<T> chunkEntities(Point point, Target<T> target) {
        return this.chunkEntities(point.chunkX(), point.chunkZ(), target);
    }

    public <T extends Entity> void nearbyEntitiesByChunkRange(Point var1, int var2, Target<T> var3, Consumer<T> var4);

    public <T extends Entity> void nearbyEntities(Point var1, double var2, Target<T> var4, Consumer<T> var5);

    public <T extends Entity> @UnmodifiableView Set<T> entities(Target<T> var1);

    default public @UnmodifiableView Set<Entity> entities() {
        return this.entities(Target.ENTITIES);
    }

    public Viewable viewable(List<SharedInstance> var1, int var2, int var3);

    default public Viewable viewable(int chunkX, int chunkZ) {
        return this.viewable(List.of(), chunkX, chunkZ);
    }

    @ApiStatus.NonExtendable
    public static interface Target<E extends Entity> {
        public static final Target<Entity> ENTITIES = Target.create(Entity.class);
        public static final Target<Player> PLAYERS = Target.create(Player.class);
        public static final Target<ItemEntity> ITEMS = Target.create(ItemEntity.class);
        public static final Target<ExperienceOrb> EXPERIENCE_ORBS = Target.create(ExperienceOrb.class);
        public static final List<Target<? extends Entity>> TARGETS = List.of(ENTITIES, PLAYERS, ITEMS, EXPERIENCE_ORBS);

        public Class<E> type();

        public int ordinal();

        private static <T extends Entity> Target<T> create(final Class<T> type) {
            final int ordinal = EntityTrackerImpl.TARGET_COUNTER.getAndIncrement();
            return new Target<T>(){

                @Override
                public Class<T> type() {
                    return type;
                }

                @Override
                public int ordinal() {
                    return ordinal;
                }
            };
        }
    }

    public static interface Update<E extends Entity> {
        public void add(E var1);

        public void remove(E var1);

        default public void referenceUpdate(Point point, @Nullable EntityTracker tracker) {
        }
    }
}

