/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identified;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.pointer.Pointered;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.pointer.PointersSupplier;
import net.kyori.adventure.sound.Sound;
import net.minestom.server.MinecraftServer;
import net.minestom.server.ServerFlag;
import net.minestom.server.ServerProcess;
import net.minestom.server.Tickable;
import net.minestom.server.adventure.AdventurePacketConvertor;
import net.minestom.server.adventure.audience.PacketGroupingAudience;
import net.minestom.server.coordinate.CoordConversion;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.EntityCreature;
import net.minestom.server.entity.ExperienceOrb;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.EventFilter;
import net.minestom.server.event.EventHandler;
import net.minestom.server.event.EventNode;
import net.minestom.server.event.instance.InstanceSectionInvalidateEvent;
import net.minestom.server.event.instance.InstanceTickEvent;
import net.minestom.server.event.trait.InstanceEvent;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.EntityTracker;
import net.minestom.server.instance.EntityTrackerImpl;
import net.minestom.server.instance.Explosion;
import net.minestom.server.instance.ExplosionSupplier;
import net.minestom.server.instance.LightingChunk;
import net.minestom.server.instance.Section;
import net.minestom.server.instance.Weather;
import net.minestom.server.instance.WorldBorder;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.generator.Generator;
import net.minestom.server.instance.light.Light;
import net.minestom.server.network.packet.server.ServerPacket;
import net.minestom.server.network.packet.server.play.BlockActionPacket;
import net.minestom.server.network.packet.server.play.InitializeWorldBorderPacket;
import net.minestom.server.network.packet.server.play.TimeUpdatePacket;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.snapshot.ChunkSnapshot;
import net.minestom.server.snapshot.InstanceSnapshot;
import net.minestom.server.snapshot.SnapshotImpl;
import net.minestom.server.snapshot.SnapshotUpdater;
import net.minestom.server.snapshot.Snapshotable;
import net.minestom.server.tag.TagHandler;
import net.minestom.server.tag.Taggable;
import net.minestom.server.timer.Schedulable;
import net.minestom.server.timer.Scheduler;
import net.minestom.server.utils.ArrayUtils;
import net.minestom.server.utils.PacketSendingUtils;
import net.minestom.server.utils.chunk.ChunkCache;
import net.minestom.server.utils.chunk.ChunkSupplier;
import net.minestom.server.utils.validate.Check;
import net.minestom.server.world.DimensionType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class Instance
implements Block.Getter,
Block.Setter,
Tickable,
Schedulable,
Snapshotable,
EventHandler<InstanceEvent>,
Taggable,
PacketGroupingAudience,
Pointered,
Identified {
    protected static final PointersSupplier<Instance> INSTANCE_POINTERS_SUPPLIER = (PointersSupplier)PointersSupplier.builder().resolving(Identity.UUID, Instance::getUuid).build();
    private boolean registered;
    private final RegistryKey<DimensionType> dimensionType;
    private final DimensionType cachedDimensionType;
    private final String dimensionName;
    private WorldBorder worldBorder;
    private double targetBorderDiameter;
    private long remainingWorldBorderTransitionTicks;
    private long worldAge;
    private long time;
    private int timeRate = 1;
    private int timeSynchronizationTicks = ServerFlag.SERVER_TICKS_PER_SECOND;
    private Weather weather = Weather.CLEAR;
    private Weather transitioningWeather = Weather.CLEAR;
    private int remainingRainTransitionTicks;
    private int remainingThunderTransitionTicks;
    private final Set<BossBar> bossBars = new CopyOnWriteArraySet<BossBar>();
    private long lastTickAge = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
    private final EntityTracker entityTracker = new EntityTrackerImpl();
    private final ChunkCache blockRetriever = new ChunkCache(this, null, null);
    protected int chunkViewDistance = ServerFlag.CHUNK_VIEW_DISTANCE;
    protected UUID uuid;
    protected TagHandler tagHandler = TagHandler.newHandler();
    private final Scheduler scheduler = Scheduler.newScheduler();
    private final EventNode<InstanceEvent> eventNode;
    private ExplosionSupplier explosionSupplier;

    public Instance(UUID uuid, RegistryKey<DimensionType> dimensionType) {
        this(uuid, dimensionType, dimensionType.key());
    }

    public Instance(UUID uuid, RegistryKey<DimensionType> dimensionType, Key dimensionName) {
        this(MinecraftServer.getDimensionTypeRegistry(), uuid, dimensionType, dimensionName);
    }

    public Instance(DynamicRegistry<DimensionType> dimensionTypeRegistry, UUID uuid, RegistryKey<DimensionType> dimensionType, Key dimensionName) {
        this.uuid = uuid;
        this.dimensionType = dimensionType;
        this.cachedDimensionType = dimensionTypeRegistry.get(dimensionType);
        Check.argCondition(this.cachedDimensionType == null, "The dimension " + String.valueOf(dimensionType) + " is not registered! Please add it to the registry (`MinecraftServer.getDimensionTypeRegistry().registry(dimensionType)`).");
        this.dimensionName = dimensionName.asString();
        this.worldBorder = WorldBorder.DEFAULT_BORDER;
        this.targetBorderDiameter = this.worldBorder.diameter();
        ServerProcess process = MinecraftServer.process();
        this.eventNode = process != null ? process.eventHandler().map(this, (EventFilter)EventFilter.INSTANCE) : null;
    }

    public void scheduleNextTick(Consumer<Instance> callback) {
        this.scheduler.scheduleNextTick(() -> callback.accept(this));
    }

    @Override
    public void setBlock(int x, int y, int z, Block block) {
        this.setBlock(x, y, z, block, true);
    }

    public void setBlock(Point blockPosition, Block block, boolean doBlockUpdates) {
        this.setBlock(blockPosition.blockX(), blockPosition.blockY(), blockPosition.blockZ(), block, doBlockUpdates);
    }

    public abstract void setBlock(int var1, int var2, int var3, Block var4, boolean var5);

    @ApiStatus.Internal
    public boolean placeBlock(BlockHandler.Placement placement) {
        return this.placeBlock(placement, true);
    }

    @ApiStatus.Internal
    public abstract boolean placeBlock(BlockHandler.Placement var1, boolean var2);

    @ApiStatus.Internal
    public boolean breakBlock(Player player, Point blockPosition, BlockFace blockFace) {
        return this.breakBlock(player, blockPosition, blockFace, true);
    }

    @ApiStatus.Internal
    public abstract boolean breakBlock(Player var1, Point var2, BlockFace var3, boolean var4);

    public abstract CompletableFuture<Chunk> loadChunk(int var1, int var2);

    public CompletableFuture<Chunk> loadChunk(Point point) {
        return this.loadChunk(point.chunkX(), point.chunkZ());
    }

    public abstract CompletableFuture<@Nullable Chunk> loadOptionalChunk(int var1, int var2);

    public CompletableFuture<@Nullable Chunk> loadOptionalChunk(Point point) {
        return this.loadOptionalChunk(point.chunkX(), point.chunkZ());
    }

    public abstract void unloadChunk(Chunk var1);

    public void unloadChunk(int chunkX, int chunkZ) {
        Chunk chunk = this.getChunk(chunkX, chunkZ);
        Check.notNull(chunk, "The chunk at {0}:{1} is already unloaded", chunkX, chunkZ);
        this.unloadChunk(chunk);
    }

    public void invalidateSection(int sectionX, int sectionY, int sectionZ) {
        Chunk chunk = this.getChunk(sectionX, sectionZ);
        if (chunk != null) {
            Section section = chunk.getSection(sectionY);
            section.skyLight().invalidate();
            section.blockLight().invalidate();
            chunk.invalidate();
            EventDispatcher.call(new InstanceSectionInvalidateEvent(this, sectionX, sectionY, sectionZ));
        }
    }

    @Nullable
    public abstract Chunk getChunk(int var1, int var2);

    public boolean isChunkLoaded(int chunkX, int chunkZ) {
        return this.getChunk(chunkX, chunkZ) != null;
    }

    public boolean isChunkLoaded(Point point) {
        return this.isChunkLoaded(point.chunkX(), point.chunkZ());
    }

    public abstract CompletableFuture<Void> saveInstance();

    public abstract CompletableFuture<Void> saveChunkToStorage(Chunk var1);

    public abstract CompletableFuture<Void> saveChunksToStorage();

    public abstract void setChunkSupplier(ChunkSupplier var1);

    public abstract ChunkSupplier getChunkSupplier();

    @Nullable
    public abstract Generator generator();

    public abstract void setGenerator(@Nullable Generator var1);

    @ApiStatus.Experimental
    public abstract CompletableFuture<Void> generateChunk(int var1, int var2, Generator var3);

    public abstract Collection<Chunk> getChunks();

    public abstract void enableAutoChunkLoad(boolean var1);

    public abstract boolean hasEnabledAutoChunkLoad();

    public abstract boolean isInVoid(Point var1);

    public boolean isRegistered() {
        return this.registered;
    }

    protected void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public RegistryKey<DimensionType> getDimensionType() {
        return this.dimensionType;
    }

    @ApiStatus.Internal
    public DimensionType getCachedDimensionType() {
        return this.cachedDimensionType;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public long getWorldAge() {
        return this.worldAge;
    }

    public void setWorldAge(long worldAge) {
        this.worldAge = worldAge;
        PacketSendingUtils.sendGroupedPacket(this.getPlayers(), this.createTimePacket());
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
        PacketSendingUtils.sendGroupedPacket(this.getPlayers(), this.createTimePacket());
    }

    public int getTimeRate() {
        return this.timeRate;
    }

    public void setTimeRate(int timeRate) {
        Check.stateCondition(timeRate < 0, "The time rate cannot be lower than 0");
        this.timeRate = timeRate;
    }

    public int getTimeSynchronizationTicks() {
        return this.timeSynchronizationTicks;
    }

    public void setTimeSynchronizationTicks(int timeSynchronizationTicks) {
        Check.stateCondition(timeSynchronizationTicks < 0, "The time Synchronization ticks cannot be lower than 0");
        this.timeSynchronizationTicks = timeSynchronizationTicks;
    }

    @ApiStatus.Internal
    public TimeUpdatePacket createTimePacket() {
        return new TimeUpdatePacket(this.worldAge, this.time, this.timeRate != 0);
    }

    public WorldBorder getWorldBorder() {
        return this.worldBorder;
    }

    public void setWorldBorder(WorldBorder worldBorder, double transitionTime) {
        long transitionTicks;
        Check.stateCondition(transitionTime < 0.0, "Transition time cannot be lower than 0");
        long transitionMilliseconds = (long)(transitionTime * 1000.0);
        this.sendNewWorldBorderPackets(worldBorder, transitionMilliseconds);
        this.targetBorderDiameter = worldBorder.diameter();
        this.remainingWorldBorderTransitionTicks = transitionTicks = transitionMilliseconds / (long)MinecraftServer.TICK_MS;
        this.worldBorder = transitionTicks == 0L ? worldBorder : worldBorder.withDiameter(this.worldBorder.diameter());
    }

    public void setWorldBorder(WorldBorder worldBorder) {
        this.setWorldBorder(worldBorder, 0.0);
    }

    public InitializeWorldBorderPacket createInitializeWorldBorderPacket() {
        return this.worldBorder.createInitializePacket(this.targetBorderDiameter, this.remainingWorldBorderTransitionTicks * (long)MinecraftServer.TICK_MS);
    }

    private void sendNewWorldBorderPackets(WorldBorder newBorder, long transitionMilliseconds) {
        if (this.worldBorder.diameter() != newBorder.diameter()) {
            if (transitionMilliseconds == 0L) {
                this.sendGroupedPacket(newBorder.createSizePacket());
            } else {
                this.sendGroupedPacket(this.worldBorder.createLerpSizePacket(newBorder.diameter(), transitionMilliseconds));
            }
        }
        if (this.worldBorder.centerX() != newBorder.centerX() || this.worldBorder.centerZ() != newBorder.centerZ()) {
            this.sendGroupedPacket(newBorder.createCenterPacket());
        }
        if (this.worldBorder.warningTime() != newBorder.warningTime()) {
            this.sendGroupedPacket(newBorder.createWarningDelayPacket());
        }
        if (this.worldBorder.warningDistance() != newBorder.warningDistance()) {
            this.sendGroupedPacket(newBorder.createWarningReachPacket());
        }
    }

    private WorldBorder transitionWorldBorder(long remainingTicks) {
        if (remainingTicks <= 1L) {
            return this.worldBorder.withDiameter(this.targetBorderDiameter);
        }
        return this.worldBorder.withDiameter(this.worldBorder.diameter() + (this.targetBorderDiameter - this.worldBorder.diameter()) * (1.0 / (double)remainingTicks));
    }

    public Set<Entity> getEntities() {
        return this.entityTracker.entities();
    }

    @Nullable
    public Entity getEntityById(int id) {
        return this.entityTracker.getEntityById(id);
    }

    @Nullable
    public Entity getEntityByUuid(UUID uuid) {
        return this.entityTracker.getEntityByUuid(uuid);
    }

    @Nullable
    public Player getPlayerByUuid(UUID uuid) {
        Entity entity = this.entityTracker.getEntityByUuid(uuid);
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }

    public Set<Player> getPlayers() {
        return this.entityTracker.entities(EntityTracker.Target.PLAYERS);
    }

    @Deprecated
    public Set<EntityCreature> getCreatures() {
        return this.entityTracker.entities().stream().filter(EntityCreature.class::isInstance).map(entity -> (EntityCreature)entity).collect(Collectors.toUnmodifiableSet());
    }

    @Deprecated
    public Set<ExperienceOrb> getExperienceOrbs() {
        return this.entityTracker.entities().stream().filter(ExperienceOrb.class::isInstance).map(entity -> (ExperienceOrb)entity).collect(Collectors.toUnmodifiableSet());
    }

    public Set<Entity> getChunkEntities(Chunk chunk) {
        Collection<Entity> chunkEntities = this.entityTracker.chunkEntities(chunk.toPosition(), EntityTracker.Target.ENTITIES);
        return ObjectArraySet.ofUnchecked((Entity[])chunkEntities.toArray(Entity[]::new));
    }

    public Collection<Entity> getNearbyEntities(Point point, double range) {
        ArrayList<Entity> result = new ArrayList<Entity>();
        this.entityTracker.nearbyEntities(point, range, EntityTracker.Target.ENTITIES, result::add);
        return result;
    }

    @Override
    @Nullable
    public Block getBlock(int x, int y, int z, Block.Getter.Condition condition) {
        Block block = this.blockRetriever.getBlock(x, y, z, condition);
        if (block == null) {
            throw new NullPointerException("Unloaded chunk at " + x + "," + y + "," + z);
        }
        return block;
    }

    public void sendBlockAction(Point blockPosition, byte actionId, byte actionParam) {
        Block block = this.getBlock(blockPosition);
        Chunk chunk = this.getChunkAt(blockPosition);
        Check.notNull(chunk, "The chunk at {0} is not loaded!", blockPosition);
        chunk.sendPacketToViewers(new BlockActionPacket(blockPosition, actionId, actionParam, block));
    }

    @Nullable
    public Chunk getChunkAt(double x, double z) {
        return this.getChunk(CoordConversion.globalToChunk(x), CoordConversion.globalToChunk(z));
    }

    @Nullable
    public Chunk getChunkAt(Point point) {
        return this.getChunk(point.chunkX(), point.chunkZ());
    }

    public EntityTracker getEntityTracker() {
        return this.entityTracker;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    @Deprecated(forRemoval=true)
    public UUID getUniqueId() {
        return this.uuid;
    }

    @Override
    public void tick(long time) {
        this.scheduler.processTick();
        ++this.worldAge;
        this.time += (long)this.timeRate;
        if (this.timeSynchronizationTicks > 0 && this.worldAge % (long)this.timeSynchronizationTicks == 0L) {
            PacketSendingUtils.sendGroupedPacket(this.getPlayers(), this.createTimePacket());
        }
        if (this.remainingRainTransitionTicks > 0 || this.remainingThunderTransitionTicks > 0) {
            Weather previousWeather = this.transitioningWeather;
            this.transitioningWeather = this.transitionWeather(this.remainingRainTransitionTicks, this.remainingThunderTransitionTicks);
            this.sendWeatherPackets(previousWeather);
            this.remainingRainTransitionTicks = Math.max(0, this.remainingRainTransitionTicks - 1);
            this.remainingThunderTransitionTicks = Math.max(0, this.remainingThunderTransitionTicks - 1);
        }
        EventDispatcher.call(new InstanceTickEvent(this, time, this.lastTickAge));
        this.lastTickAge = time;
        if (this.remainingWorldBorderTransitionTicks > 0L) {
            this.worldBorder = this.transitionWorldBorder(this.remainingWorldBorderTransitionTicks);
            this.remainingWorldBorderTransitionTicks = this.worldBorder.diameter() == this.targetBorderDiameter ? 0L : --this.remainingWorldBorderTransitionTicks;
        }
        this.scheduler.processTickEnd();
    }

    public Weather getWeather() {
        return this.weather;
    }

    public void setWeather(Weather weather, int transitionTicks) {
        Check.stateCondition(transitionTicks < 1, "Transition ticks cannot be lower than 0");
        this.weather = weather;
        this.remainingRainTransitionTicks = transitionTicks;
        this.remainingThunderTransitionTicks = transitionTicks;
    }

    public void setWeather(Weather weather) {
        this.weather = weather;
        this.remainingRainTransitionTicks = (int)Math.max(1.0, Math.abs((double)(this.weather.rainLevel() - this.transitioningWeather.rainLevel()) / 0.01));
        this.remainingThunderTransitionTicks = (int)Math.max(1.0, Math.abs((double)(this.weather.thunderLevel() - this.transitioningWeather.thunderLevel()) / 0.01));
    }

    private void sendWeatherPackets(Weather previousWeather) {
        boolean toggledRain;
        boolean bl = toggledRain = this.transitioningWeather.isRaining() != previousWeather.isRaining();
        if (toggledRain) {
            this.sendGroupedPacket(this.transitioningWeather.createIsRainingPacket());
        }
        if (this.transitioningWeather.rainLevel() != previousWeather.rainLevel()) {
            this.sendGroupedPacket(this.transitioningWeather.createRainLevelPacket());
        }
        if (this.transitioningWeather.thunderLevel() != previousWeather.thunderLevel()) {
            this.sendGroupedPacket(this.transitioningWeather.createThunderLevelPacket());
        }
    }

    private Weather transitionWeather(int remainingRainTransitionTicks, int remainingThunderTransitionTicks) {
        Weather target = this.weather;
        Weather current = this.transitioningWeather;
        float rainLevel = current.rainLevel() + (target.rainLevel() - current.rainLevel()) * (1.0f / (float)Math.max(1, remainingRainTransitionTicks));
        float thunderLevel = current.thunderLevel() + (target.thunderLevel() - current.thunderLevel()) * (1.0f / (float)Math.max(1, remainingThunderTransitionTicks));
        return new Weather(rainLevel, thunderLevel);
    }

    public int viewDistance() {
        return this.chunkViewDistance;
    }

    public void viewDistance(int newViewDistance) {
        this.chunkViewDistance = newViewDistance;
    }

    @Override
    public void showBossBar(BossBar bar) {
        Check.notNull(bar, "Boss bar cannot be null");
        if (!this.bossBars.add(bar)) {
            return;
        }
        PacketGroupingAudience.super.showBossBar(bar);
    }

    @Override
    public void hideBossBar(BossBar bar) {
        Check.notNull(bar, "Boss bar cannot be null");
        if (!this.bossBars.remove(bar)) {
            return;
        }
        PacketGroupingAudience.super.hideBossBar(bar);
    }

    @ApiStatus.Experimental
    public @UnmodifiableView Set<BossBar> bossBars() {
        return Collections.unmodifiableSet(this.bossBars);
    }

    @Override
    public TagHandler tagHandler() {
        return this.tagHandler;
    }

    @Override
    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    @ApiStatus.Experimental
    public EventNode<InstanceEvent> eventNode() {
        return this.eventNode;
    }

    @Override
    public InstanceSnapshot updateSnapshot(SnapshotUpdater updater) {
        Map<Long, AtomicReference<ChunkSnapshot>> chunksMap = updater.referencesMapLong(this.getChunks(), value -> CoordConversion.chunkIndex(value.getChunkX(), value.getChunkZ()));
        int[] entities = ArrayUtils.mapToIntArray(this.entityTracker.entities(), Entity::getEntityId);
        return new SnapshotImpl.Instance(updater.reference(MinecraftServer.process()), this.getDimensionType(), this.getWorldAge(), this.getTime(), chunksMap, entities, this.tagHandler.readableCopy());
    }

    public void playSoundExcept(@Nullable Player excludedPlayer, Sound sound, Point point) {
        this.playSoundExcept(excludedPlayer, sound, point.x(), point.y(), point.z());
    }

    public void playSoundExcept(@Nullable Player excludedPlayer, Sound sound, double x, double y, double z) {
        ServerPacket packet = AdventurePacketConvertor.createSoundPacket(sound, x, y, z);
        PacketSendingUtils.sendGroupedPacket(this.getPlayers(), packet, p -> p != excludedPlayer);
    }

    public void playSoundExcept(@Nullable Player excludedPlayer, Sound sound, Sound.Emitter emitter) {
        if (emitter != Sound.Emitter.self()) {
            ServerPacket packet = AdventurePacketConvertor.createSoundPacket(sound, emitter);
            PacketSendingUtils.sendGroupedPacket(this.getPlayers(), packet, p -> p != excludedPlayer);
        } else {
            for (Audience audience : this.audiences()) {
                if (audience == excludedPlayer) continue;
                audience.playSound(sound, emitter);
            }
        }
    }

    public void explode(float centerX, float centerY, float centerZ, float strength) {
        this.explode(centerX, centerY, centerZ, strength, null);
    }

    public void explode(float centerX, float centerY, float centerZ, float strength, @Nullable CompoundBinaryTag additionalData) {
        ExplosionSupplier explosionSupplier = this.getExplosionSupplier();
        Check.stateCondition(explosionSupplier == null, "Tried to create an explosion with no explosion supplier");
        Explosion explosion = explosionSupplier.createExplosion(centerX, centerY, centerZ, strength, additionalData);
        explosion.apply(this);
    }

    @Nullable
    public ExplosionSupplier getExplosionSupplier() {
        return this.explosionSupplier;
    }

    public void setExplosionSupplier(@Nullable ExplosionSupplier supplier) {
        this.explosionSupplier = supplier;
    }

    @Override
    @Contract(pure=true)
    public Pointers pointers() {
        return INSTANCE_POINTERS_SUPPLIER.view(this);
    }

    @Override
    @Contract(pure=true)
    public Identity identity() {
        return Identity.identity(this.uuid);
    }

    public int getBlockLight(int blockX, int blockY, int blockZ) {
        Chunk chunk = this.getChunkAt(blockX, blockZ);
        if (chunk == null) {
            return 0;
        }
        Section section = chunk.getSectionAt(blockY);
        Light light = section.blockLight();
        int sectionCoordinate = CoordConversion.globalToChunk(blockY);
        int coordX = CoordConversion.globalToSectionRelative(blockX);
        int coordY = CoordConversion.globalToSectionRelative(blockY);
        int coordZ = CoordConversion.globalToSectionRelative(blockZ);
        if (light.requiresUpdate()) {
            LightingChunk.relightSection(chunk.getInstance(), chunk.chunkX, sectionCoordinate, chunk.chunkZ);
        }
        return light.getLevel(coordX, coordY, coordZ);
    }

    public int getSkyLight(int blockX, int blockY, int blockZ) {
        Chunk chunk = this.getChunkAt(blockX, blockZ);
        if (chunk == null) {
            return 0;
        }
        Section section = chunk.getSectionAt(blockY);
        Light light = section.skyLight();
        int sectionCoordinate = CoordConversion.globalToChunk(blockY);
        int coordX = CoordConversion.globalToSectionRelative(blockX);
        int coordY = CoordConversion.globalToSectionRelative(blockY);
        int coordZ = CoordConversion.globalToSectionRelative(blockZ);
        if (light.requiresUpdate()) {
            LightingChunk.relightSection(chunk.getInstance(), chunk.chunkX, sectionCoordinate, chunk.chunkZ);
        }
        return light.getLevel(coordX, coordY, coordZ);
    }
}

