/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Player;
import net.minestom.server.instance.Chunk;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.InstanceContainer;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.instance.block.BlockHandler;
import net.minestom.server.instance.generator.Generator;
import net.minestom.server.utils.chunk.ChunkSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class SharedInstance
extends Instance {
    private final InstanceContainer instanceContainer;

    public SharedInstance(UUID uuid, InstanceContainer instanceContainer) {
        super(uuid, instanceContainer.getDimensionType());
        this.instanceContainer = instanceContainer;
    }

    @Override
    public void setBlock(int x, int y, int z, Block block, boolean doBlockUpdates) {
        this.instanceContainer.setBlock(x, y, z, block, doBlockUpdates);
    }

    @Override
    public boolean placeBlock(BlockHandler.Placement placement, boolean doBlockUpdates) {
        return this.instanceContainer.placeBlock(placement, doBlockUpdates);
    }

    @Override
    public boolean breakBlock(Player player, Point blockPosition, BlockFace blockFace, boolean doBlockUpdates) {
        return this.instanceContainer.breakBlock(player, blockPosition, blockFace, doBlockUpdates);
    }

    @Override
    public CompletableFuture<Chunk> loadChunk(int chunkX, int chunkZ) {
        return this.instanceContainer.loadChunk(chunkX, chunkZ);
    }

    @Override
    public CompletableFuture<Chunk> loadOptionalChunk(int chunkX, int chunkZ) {
        return this.instanceContainer.loadOptionalChunk(chunkX, chunkZ);
    }

    @Override
    public void unloadChunk(Chunk chunk) {
        this.instanceContainer.unloadChunk(chunk);
    }

    @Override
    public Chunk getChunk(int chunkX, int chunkZ) {
        return this.instanceContainer.getChunk(chunkX, chunkZ);
    }

    @Override
    public CompletableFuture<Void> saveInstance() {
        return this.instanceContainer.saveInstance();
    }

    @Override
    public CompletableFuture<Void> saveChunkToStorage(Chunk chunk) {
        return this.instanceContainer.saveChunkToStorage(chunk);
    }

    @Override
    public CompletableFuture<Void> saveChunksToStorage() {
        return this.instanceContainer.saveChunksToStorage();
    }

    @Override
    public void setChunkSupplier(ChunkSupplier chunkSupplier) {
        this.instanceContainer.setChunkSupplier(chunkSupplier);
    }

    @Override
    public ChunkSupplier getChunkSupplier() {
        return this.instanceContainer.getChunkSupplier();
    }

    @Override
    @Nullable
    public Generator generator() {
        return this.instanceContainer.generator();
    }

    @Override
    public void setGenerator(@Nullable Generator generator) {
        this.instanceContainer.setGenerator(generator);
    }

    @Override
    @ApiStatus.Experimental
    public CompletableFuture<Void> generateChunk(int chunkX, int chunkZ, Generator generator) {
        return this.instanceContainer.generateChunk(chunkX, chunkZ, generator);
    }

    @Override
    public Collection<Chunk> getChunks() {
        return this.instanceContainer.getChunks();
    }

    @Override
    public void enableAutoChunkLoad(boolean enable) {
        this.instanceContainer.enableAutoChunkLoad(enable);
    }

    @Override
    public boolean hasEnabledAutoChunkLoad() {
        return this.instanceContainer.hasEnabledAutoChunkLoad();
    }

    @Override
    public boolean isInVoid(Point point) {
        return this.instanceContainer.isInVoid(point);
    }

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public static boolean areLinked(Instance instance1, Instance instance2) {
        if (instance1 instanceof InstanceContainer && instance2 instanceof SharedInstance) {
            return ((SharedInstance)instance2).getInstanceContainer().equals(instance1);
        }
        if (instance2 instanceof InstanceContainer && instance1 instanceof SharedInstance) {
            return ((SharedInstance)instance1).getInstanceContainer().equals(instance2);
        }
        if (instance1 instanceof SharedInstance && instance2 instanceof SharedInstance) {
            InstanceContainer container1 = ((SharedInstance)instance1).getInstanceContainer();
            InstanceContainer container2 = ((SharedInstance)instance2).getInstanceContainer();
            return container1.equals(container2);
        }
        if (instance1 instanceof InstanceContainer) {
            InstanceContainer container1 = (InstanceContainer)instance1;
            if (instance2 instanceof InstanceContainer) {
                InstanceContainer container2 = (InstanceContainer)instance2;
                if (container1.getSrcInstance() != null) {
                    return container1.getSrcInstance().equals(container2) && container1.getLastBlockChangeTime() == container2.getLastBlockChangeTime();
                }
                if (container2.getSrcInstance() != null) {
                    return container2.getSrcInstance().equals(container1) && container2.getLastBlockChangeTime() == container1.getLastBlockChangeTime();
                }
            }
        }
        return false;
    }
}

