/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import net.minestom.server.utils.Direction;

public enum BlockFace {
    BOTTOM(Direction.DOWN),
    TOP(Direction.UP),
    NORTH(Direction.NORTH),
    SOUTH(Direction.SOUTH),
    WEST(Direction.WEST),
    EAST(Direction.EAST);

    private final Direction direction;

    private BlockFace(Direction direction) {
        this.direction = direction;
    }

    public Direction toDirection() {
        return this.direction;
    }

    public BlockFace getOppositeFace() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> TOP;
            case 1 -> BOTTOM;
            case 2 -> SOUTH;
            case 3 -> NORTH;
            case 4 -> EAST;
            case 5 -> WEST;
        };
    }

    public boolean isSimilar(BlockFace other) {
        return this == other || this == other.getOppositeFace();
    }

    public static BlockFace fromYaw(float yaw) {
        float degrees = (yaw - 90.0f) % 360.0f;
        if (degrees < 0.0f) {
            degrees += 360.0f;
        }
        if (0.0f <= degrees && degrees < 45.0f) {
            return WEST;
        }
        if (45.0f <= degrees && degrees < 135.0f) {
            return NORTH;
        }
        if (135.0f <= degrees && degrees < 225.0f) {
            return EAST;
        }
        if (225.0f <= degrees && degrees < 315.0f) {
            return SOUTH;
        }
        return WEST;
    }

    public static BlockFace fromDirection(Direction direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> TOP;
            case Direction.DOWN -> BOTTOM;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }
}

