/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.key.Key;
import net.minestom.server.coordinate.Point;
import net.minestom.server.entity.Entity;
import net.minestom.server.entity.Player;
import net.minestom.server.entity.PlayerHand;
import net.minestom.server.instance.Instance;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.block.BlockFace;
import net.minestom.server.tag.Tag;
import org.jetbrains.annotations.ApiStatus;

public interface BlockHandler {
    default public void onPlace(Placement placement) {
    }

    default public void onDestroy(Destroy destroy) {
    }

    default public boolean onInteract(Interaction interaction) {
        return true;
    }

    default public void onTouch(Touch touch) {
    }

    default public void tick(Tick tick) {
    }

    default public boolean isTickable() {
        return false;
    }

    default public Collection<Tag<?>> getBlockEntityTags() {
        return List.of();
    }

    default public byte getBlockEntityAction() {
        return -1;
    }

    public Key getKey();

    @ApiStatus.Internal
    public static final class Dummy
    implements BlockHandler {
        private static final Map<String, BlockHandler> DUMMY_CACHE = new ConcurrentHashMap<String, BlockHandler>();
        private final Key key;

        public static BlockHandler get(String namespace) {
            return DUMMY_CACHE.computeIfAbsent(namespace, Dummy::new);
        }

        private Dummy(String name) {
            this.key = Key.key(name);
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }

    public static final class Tick {
        private final Block block;
        private final Instance instance;
        private final Point blockPosition;

        @ApiStatus.Internal
        public Tick(Block block, Instance instance, Point blockPosition) {
            this.block = block;
            this.instance = instance;
            this.blockPosition = blockPosition;
        }

        public Block getBlock() {
            return this.block;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public Point getBlockPosition() {
            return this.blockPosition;
        }
    }

    public static final class Touch {
        private final Block block;
        private final Instance instance;
        private final Point blockPosition;
        private final Entity touching;

        @ApiStatus.Internal
        public Touch(Block block, Instance instance, Point blockPosition, Entity touching) {
            this.block = block;
            this.instance = instance;
            this.blockPosition = blockPosition;
            this.touching = touching;
        }

        public Block getBlock() {
            return this.block;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public Point getBlockPosition() {
            return this.blockPosition;
        }

        public Entity getTouching() {
            return this.touching;
        }
    }

    public static final class Interaction {
        private final Block block;
        private final Instance instance;
        private final BlockFace blockFace;
        private final Point blockPosition;
        private final Point cursorPosition;
        private final Player player;
        private final PlayerHand hand;

        @ApiStatus.Internal
        public Interaction(Block block, Instance instance, BlockFace blockFace, Point blockPosition, Point cursorPosition, Player player, PlayerHand hand) {
            this.block = block;
            this.instance = instance;
            this.blockFace = blockFace;
            this.blockPosition = blockPosition;
            this.cursorPosition = cursorPosition;
            this.player = player;
            this.hand = hand;
        }

        public Block getBlock() {
            return this.block;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public BlockFace getBlockFace() {
            return this.blockFace;
        }

        public Point getBlockPosition() {
            return this.blockPosition;
        }

        public Point getCursorPosition() {
            return this.cursorPosition;
        }

        public Player getPlayer() {
            return this.player;
        }

        public PlayerHand getHand() {
            return this.hand;
        }
    }

    public static final class PlayerDestroy
    extends Destroy {
        private final Player player;

        @ApiStatus.Internal
        public PlayerDestroy(Block block, Block newBlock, Instance instance, Point blockPosition, Player player) {
            super(block, newBlock, instance, blockPosition);
            this.player = player;
        }

        public Player getPlayer() {
            return this.player;
        }
    }

    public static sealed class Destroy
    permits PlayerDestroy {
        private final Block block;
        private final Block newBlock;
        private final Instance instance;
        private final Point blockPosition;

        @ApiStatus.Internal
        public Destroy(Block block, Block newBlock, Instance instance, Point blockPosition) {
            this.block = block;
            this.newBlock = newBlock;
            this.instance = instance;
            this.blockPosition = blockPosition;
        }

        public Block getBlock() {
            return this.block;
        }

        public Block getNewBlock() {
            return this.newBlock;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public Point getBlockPosition() {
            return this.blockPosition;
        }
    }

    public static final class PlayerPlacement
    extends Placement {
        private final Player player;
        private final PlayerHand hand;
        private final BlockFace blockFace;
        private final float cursorX;
        private final float cursorY;
        private final float cursorZ;

        @ApiStatus.Internal
        public PlayerPlacement(Block block, Block previousBlock, Instance instance, Point blockPosition, Player player, PlayerHand hand, BlockFace blockFace, float cursorX, float cursorY, float cursorZ) {
            super(block, previousBlock, instance, blockPosition);
            this.player = player;
            this.hand = hand;
            this.blockFace = blockFace;
            this.cursorX = cursorX;
            this.cursorY = cursorY;
            this.cursorZ = cursorZ;
        }

        public Player getPlayer() {
            return this.player;
        }

        public PlayerHand getHand() {
            return this.hand;
        }

        public BlockFace getBlockFace() {
            return this.blockFace;
        }

        public float getCursorX() {
            return this.cursorX;
        }

        public float getCursorY() {
            return this.cursorY;
        }

        public float getCursorZ() {
            return this.cursorZ;
        }
    }

    public static sealed class Placement
    permits PlayerPlacement {
        private final Block block;
        private final Block previousBlock;
        private final Instance instance;
        private final Point blockPosition;

        @ApiStatus.Internal
        public Placement(Block block, Block previousBlock, Instance instance, Point blockPosition) {
            this.block = block;
            this.previousBlock = previousBlock;
            this.instance = instance;
            this.blockPosition = blockPosition;
        }

        public Block getBlock() {
            return this.block;
        }

        public Block getPreviousBlock() {
            return this.previousBlock;
        }

        public Instance getInstance() {
            return this.instance;
        }

        public Point getBlockPosition() {
            return this.blockPosition;
        }
    }
}

