/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.jukebox;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.instance.block.jukebox.JukeboxSongImpl;
import net.minestom.server.instance.block.jukebox.JukeboxSongs;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.RegistryKey;
import net.minestom.server.sound.SoundEvent;
import net.minestom.server.utils.Either;
import org.jetbrains.annotations.ApiStatus;

public sealed interface JukeboxSong
extends Holder.Direct<JukeboxSong>,
JukeboxSongs
permits JukeboxSongImpl {
    public static final NetworkBuffer.Type<JukeboxSong> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(SoundEvent.NETWORK_TYPE, JukeboxSong::soundEvent, NetworkBuffer.COMPONENT, JukeboxSong::description, NetworkBuffer.FLOAT, JukeboxSong::lengthInSeconds, NetworkBuffer.VAR_INT, JukeboxSong::comparatorOutput, JukeboxSong::create);
    public static final Codec<JukeboxSong> REGISTRY_CODEC = StructCodec.struct("sound_event", SoundEvent.CODEC, JukeboxSong::soundEvent, "description", Codec.COMPONENT, JukeboxSong::description, "length_in_seconds", Codec.FLOAT, JukeboxSong::lengthInSeconds, "comparator_output", Codec.INT, JukeboxSong::comparatorOutput, JukeboxSong::create);
    public static final NetworkBuffer.Type<RegistryKey<JukeboxSong>> NETWORK_TYPE = Holder.networkType(Registries::jukeboxSong, REGISTRY_NETWORK_TYPE).transform(Holder::asKey, key -> key);
    public static final Codec<RegistryKey<JukeboxSong>> CODEC = RegistryKey.codec(Registries::jukeboxSong);
    public static final NetworkBuffer.Type<RegistryKey<JukeboxSong>> JUKEBOX_PLAYABLE_NETWORK_TYPE = NetworkBuffer.Either(NETWORK_TYPE, NETWORK_TYPE).transform(e -> (RegistryKey)((Either.Left)e).value(), Either::left);

    public static JukeboxSong create(SoundEvent soundEvent, Component description, float lengthInSeconds, int comparatorOutput) {
        return new JukeboxSongImpl(soundEvent, description, lengthInSeconds, comparatorOutput);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<JukeboxSong> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("jukebox_song"), REGISTRY_CODEC, RegistryData.Resource.JUKEBOX_SONGS);
    }

    public SoundEvent soundEvent();

    public Component description();

    public float lengthInSeconds();

    public int comparatorOutput();

    public static final class Builder {
        private SoundEvent soundEvent;
        private Component description;
        private float lengthInSeconds;
        private int comparatorOutput = 0;

        private Builder() {
        }

        public Builder soundEvent(SoundEvent soundEvent) {
            this.soundEvent = soundEvent;
            return this;
        }

        public Builder description(Component description) {
            this.description = description;
            return this;
        }

        public Builder lengthInSeconds(float lengthInSeconds) {
            this.lengthInSeconds = lengthInSeconds;
            return this;
        }

        public Builder comparatorOutput(int comparatorOutput) {
            this.comparatorOutput = comparatorOutput;
            return this;
        }

        public JukeboxSong build() {
            return new JukeboxSongImpl(this.soundEvent, this.description, this.lengthInSeconds, this.comparatorOutput);
        }
    }
}

