/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.block.predicate;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.instance.block.Block;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import org.jetbrains.annotations.Nullable;

public record PropertiesPredicate(Map<String, ValuePredicate> properties) implements Predicate<Block>
{
    public static final NetworkBuffer.Type<PropertiesPredicate> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.STRING.mapValue(ValuePredicate.NETWORK_TYPE), PropertiesPredicate::properties, PropertiesPredicate::new);
    public static final Codec<PropertiesPredicate> CODEC = Codec.STRING.mapValue(ValuePredicate.CODEC).transform(PropertiesPredicate::new, PropertiesPredicate::properties);

    public PropertiesPredicate {
        properties = Map.copyOf(properties);
    }

    public static PropertiesPredicate exact(String key, String value) {
        return new PropertiesPredicate(Map.of(key, new ValuePredicate.Exact(value)));
    }

    @Override
    public boolean test(Block block) {
        for (Map.Entry<String, ValuePredicate> entry : this.properties.entrySet()) {
            String value = block.getProperty(entry.getKey());
            if (entry.getValue().test(value)) continue;
            return false;
        }
        return true;
    }

    public static sealed interface ValuePredicate
    extends Predicate<String> {
        public static final NetworkBuffer.Type<ValuePredicate> NETWORK_TYPE = new NetworkBuffer.Type<ValuePredicate>(){

            @Override
            public void write(NetworkBuffer buffer, ValuePredicate value) {
                ValuePredicate valuePredicate = value;
                Objects.requireNonNull(valuePredicate);
                ValuePredicate valuePredicate2 = valuePredicate;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class}, (ValuePredicate)valuePredicate2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Exact exact = (Exact)valuePredicate2;
                        buffer.write(NetworkBuffer.BOOLEAN, true);
                        buffer.write(Exact.NETWORK_TYPE, exact);
                        break;
                    }
                    case 1: {
                        Range range = (Range)valuePredicate2;
                        buffer.write(NetworkBuffer.BOOLEAN, false);
                        buffer.write(Range.NETWORK_TYPE, range);
                    }
                }
            }

            @Override
            public ValuePredicate read(NetworkBuffer buffer) {
                return buffer.read(NetworkBuffer.BOOLEAN) != false ? (ValuePredicate)buffer.read(Exact.NETWORK_TYPE) : (ValuePredicate)buffer.read(Range.NETWORK_TYPE);
            }
        };
        public static final Codec<ValuePredicate> CODEC = new Codec<ValuePredicate>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public <D> Result<ValuePredicate> decode(Transcoder<D> coder, D value) {
                Result exactResult = Exact.CODEC.decode(coder, value);
                if (exactResult instanceof Result.Ok) {
                    Exact exact;
                    Result.Ok ok = (Result.Ok)exactResult;
                    Exact exact2 = exact = (Exact)ok.value();
                    return new Result.Ok<ValuePredicate>(exact2);
                }
                Result rangeResult = Range.CODEC.decode(coder, value);
                if (!(rangeResult instanceof Result.Ok)) return new Result.Error<ValuePredicate>("Invalid value predicate");
                Result.Ok ok = (Result.Ok)rangeResult;
                try {
                    Range range;
                    Range range2 = range = (Range)ok.value();
                    return new Result.Ok<ValuePredicate>(range2);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }

            @Override
            public <D> Result<D> encode(Transcoder<D> coder, @Nullable ValuePredicate value) {
                if (value == null) {
                    return new Result.Error("null");
                }
                ValuePredicate valuePredicate = value;
                Objects.requireNonNull(valuePredicate);
                ValuePredicate valuePredicate2 = valuePredicate;
                int n = 0;
                return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Exact.class, Range.class}, (ValuePredicate)valuePredicate2, n)) {
                    default -> throw new MatchException(null, null);
                    case 0 -> {
                        Exact exact = (Exact)valuePredicate2;
                        yield Exact.CODEC.encode(coder, exact);
                    }
                    case 1 -> {
                        Range range = (Range)valuePredicate2;
                        yield Range.CODEC.encode(coder, range);
                    }
                };
            }
        };

        public record Range(@Nullable String min, @Nullable String max) implements ValuePredicate
        {
            public static final NetworkBuffer.Type<Range> NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.STRING.optional(), Range::min, NetworkBuffer.STRING.optional(), Range::max, Range::new);
            public static final Codec<Range> CODEC = StructCodec.struct("min", Codec.STRING.optional(), Range::min, "max", Codec.STRING.optional(), Range::max, Range::new);

            @Override
            public boolean test(@Nullable String prop) {
                if (prop == null || this.min == null && this.max == null) {
                    return false;
                }
                try {
                    int value = Integer.parseInt(prop);
                    return !(this.min != null && value < Integer.parseInt(this.min) || this.max != null && value >= Integer.parseInt(this.max));
                }
                catch (NumberFormatException e) {
                    return !(this.min != null && prop.compareTo(this.min) < 0 || this.max != null && prop.compareTo(this.max) >= 0);
                }
            }
        }

        public record Exact(@Nullable String value) implements ValuePredicate
        {
            public static final NetworkBuffer.Type<Exact> NETWORK_TYPE = NetworkBuffer.STRING.transform(Exact::new, Exact::value);
            public static final Codec<Exact> CODEC = Codec.STRING.transform(Exact::new, Exact::value);

            @Override
            public boolean test(@Nullable String prop) {
                return prop != null && prop.equals(this.value);
            }
        }
    }
}

