/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.instance.generator;

import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minestom.server.coordinate.Point;
import net.minestom.server.coordinate.Vec;
import net.minestom.server.instance.block.Block;
import net.minestom.server.instance.generator.UnitModifier;

public interface GenerationUnit {
    public UnitModifier modifier();

    public Point size();

    public Point absoluteStart();

    public Point absoluteEnd();

    public GenerationUnit fork(Point var1, Point var2);

    public void fork(Consumer<Block.Setter> var1);

    default public List<GenerationUnit> subdivide() {
        return List.of(this);
    }

    default public Set<Vec> sections() {
        Point start = this.absoluteStart();
        Point end = this.absoluteEnd();
        int minX = start.sectionX();
        int minY = start.sectionY();
        int minZ = start.sectionZ();
        int maxX = end.sectionX();
        int maxY = end.sectionY();
        int maxZ = end.sectionZ();
        int count = (maxX - minX) * (maxY - minY) * (maxZ - minZ);
        Vec[] sections = new Vec[count];
        int index = 0;
        for (int sectionX = minX; sectionX < maxX; ++sectionX) {
            for (int sectionY = minY; sectionY < maxY; ++sectionY) {
                for (int sectionZ = minZ; sectionZ < maxZ; ++sectionZ) {
                    sections[index++] = new Vec(sectionX, sectionY, sectionZ);
                }
            }
        }
        return Set.of(sections);
    }
}

