/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.kyori.adventure.text.Component;
import net.minestom.server.entity.Player;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.InventoryProperty;
import net.minestom.server.inventory.InventoryType;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.network.packet.server.play.OpenWindowPacket;
import net.minestom.server.network.packet.server.play.WindowPropertyPacket;

public non-sealed class Inventory
extends AbstractInventory {
    private static final AtomicInteger ID_COUNTER = new AtomicInteger();
    private final byte id = Inventory.generateId();
    private final InventoryType inventoryType;
    private Component title;
    private final int offset;

    public Inventory(InventoryType inventoryType, Component title) {
        super(inventoryType.getSize());
        this.inventoryType = inventoryType;
        this.title = title;
        this.offset = this.getSize();
    }

    public Inventory(InventoryType inventoryType, String title) {
        this(inventoryType, Component.text(title));
    }

    private static byte generateId() {
        return (byte)ID_COUNTER.updateAndGet(i -> i + 1 >= 128 ? 1 : i + 1);
    }

    public InventoryType getInventoryType() {
        return this.inventoryType;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setTitle(Component title) {
        this.title = title;
        this.sendPacketToViewers(new OpenWindowPacket(this.getWindowId(), this.getInventoryType().getWindowType(), title));
        this.update();
    }

    @Override
    public byte getWindowId() {
        return this.id;
    }

    @Override
    public boolean addViewer(Player player) {
        if (!this.viewers.add(player)) {
            return false;
        }
        player.sendPacket(new OpenWindowPacket(this.id, this.getInventoryType().getWindowType(), this.title));
        this.update(player);
        return true;
    }

    @Override
    public boolean removeViewer(Player player) {
        if (!super.removeViewer(player)) {
            return false;
        }
        player.getClickPreprocessor().clearCache();
        return true;
    }

    @Deprecated
    public ItemStack getCursorItem(Player player) {
        return player.getInventory().getCursorItem();
    }

    @Deprecated
    public void setCursorItem(Player player, ItemStack cursorItem) {
        player.getInventory().setCursorItem(cursorItem);
    }

    protected void sendProperty(InventoryProperty property, short value) {
        this.sendPacketToViewers(new WindowPropertyPacket(this.getWindowId(), property.getProperty(), value));
    }

    @Override
    public boolean leftClick(Player player, int slot) {
        PlayerInventory playerInventory = player.getInventory();
        ItemStack cursor = playerInventory.getCursorItem();
        boolean isInWindow = this.isClickInWindow(slot);
        int clickSlot = isInWindow ? slot : slot - this.offset;
        AbstractInventory clickedInventory = isInWindow ? this : playerInventory;
        ItemStack clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot);
        InventoryClickResult clickResult = this.clickProcessor.leftClick(clicked, cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, clickedInventory, slot, ClickType.LEFT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean rightClick(Player player, int slot) {
        PlayerInventory playerInventory = player.getInventory();
        ItemStack cursor = playerInventory.getCursorItem();
        boolean isInWindow = this.isClickInWindow(slot);
        int clickSlot = isInWindow ? slot : slot - this.offset;
        ItemStack clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot);
        AbstractInventory clickedInventory = isInWindow ? this : playerInventory;
        InventoryClickResult clickResult = this.clickProcessor.rightClick(clicked, cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        this.callClickEvent(player, clickedInventory, slot, ClickType.RIGHT_CLICK, clicked, cursor);
        return true;
    }

    @Override
    public boolean shiftClick(Player player, int slot, int button) {
        InventoryClickResult clickResult;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        int clickSlot = isInWindow ? slot : slot - this.offset;
        ItemStack clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot);
        ItemStack cursor = playerInventory.getCursorItem();
        if (isInWindow) {
            clickResult = this.clickProcessor.shiftClick(this, playerInventory, 8, 0, -1, player, clickSlot, clicked, cursor);
            if (clickResult.isCancel()) {
                clickResult = this.clickProcessor.shiftClick(this, playerInventory, playerInventory.getInnerSize() - 1, 0, -1, player, clickSlot, clicked, cursor);
            }
        } else {
            clickResult = this.clickProcessor.shiftClick(playerInventory, this, 0, this.getInnerSize(), 1, player, clickSlot, clicked, cursor);
        }
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        this.updateAll(player);
        playerInventory.setCursorItem(clickResult.getCursor());
        return true;
    }

    @Override
    public boolean changeHeld(Player player, int slot, int key) {
        int convertedKey = key == 40 ? 45 : key;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        int clickSlot = isInWindow ? slot : slot - this.offset;
        ItemStack clicked = isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot);
        ItemStack heldItem = playerInventory.getItemStack(convertedKey);
        AbstractInventory clickedInventory = isInWindow ? this : playerInventory;
        InventoryClickResult clickResult = this.clickProcessor.changeHeld(clicked, heldItem);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        if (isInWindow) {
            this.setItemStack(slot, clickResult.getClicked());
        } else {
            playerInventory.setItemStack(clickSlot, clickResult.getClicked());
        }
        playerInventory.setItemStack(convertedKey, clickResult.getCursor());
        this.callClickEvent(player, clickedInventory, slot, ClickType.CHANGE_HELD, clicked, playerInventory.getCursorItem());
        return true;
    }

    @Override
    public boolean middleClick(Player player, int slot) {
        this.update(player);
        return false;
    }

    @Override
    public boolean drop(Player player, boolean all, int slot) {
        ItemStack cursor;
        int clickSlot;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        boolean outsideDrop = slot == -999;
        int n = clickSlot = isInWindow ? slot : slot - this.offset;
        ItemStack clicked = outsideDrop ? ItemStack.AIR : (isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot));
        InventoryClickResult clickResult = this.clickProcessor.drop(player, all, clickSlot, clicked, cursor = playerInventory.getCursorItem());
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        ItemStack resultClicked = clickResult.getClicked();
        if (!outsideDrop && resultClicked != null) {
            if (isInWindow) {
                this.setItemStack(slot, resultClicked);
            } else {
                playerInventory.setItemStack(clickSlot, resultClicked);
            }
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        return true;
    }

    @Override
    public boolean dragging(Player player, List<Integer> slots, int button) {
        PlayerInventory playerInventory = player.getInventory();
        ItemStack cursor = playerInventory.getCursorItem();
        ItemStack clickResult = this.clickProcessor.dragging(player, this, slots, button, cursor);
        if (clickResult == null) {
            this.updateAll(player);
            return false;
        }
        playerInventory.setCursorItem(clickResult);
        this.updateAll(player);
        return true;
    }

    @Override
    public boolean doubleClick(Player player, int slot) {
        int clickSlot;
        PlayerInventory playerInventory = player.getInventory();
        boolean isInWindow = this.isClickInWindow(slot);
        int n = clickSlot = isInWindow ? slot : slot - this.offset;
        ItemStack clicked = slot != -999 ? (isInWindow ? this.getItemStack(slot) : playerInventory.getItemStack(clickSlot)) : ItemStack.AIR;
        ItemStack cursor = playerInventory.getCursorItem();
        InventoryClickResult clickResult = this.clickProcessor.doubleClick(isInWindow ? this : playerInventory, this, player, clickSlot, clicked, cursor);
        if (clickResult.isCancel()) {
            this.updateAll(player);
            return false;
        }
        playerInventory.setCursorItem(clickResult.getCursor());
        this.updateAll(player);
        return true;
    }

    private boolean isClickInWindow(int slot) {
        return slot < this.getSize();
    }

    private void updateAll(Player player) {
        player.getInventory().update();
        this.update(player);
    }
}

