/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory;

import it.unimi.dsi.fastutil.Pair;
import java.util.Map;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.item.ItemStack;

@FunctionalInterface
public interface TransactionOption<T> {
    public static final TransactionOption<ItemStack> ALL = (inventory, result, itemChangesMap) -> {
        itemChangesMap.forEach(inventory::setItemStack);
        return result;
    };
    public static final TransactionOption<Boolean> ALL_OR_NOTHING = (inventory, result, itemChangesMap) -> {
        if (result.isAir()) {
            itemChangesMap.forEach(inventory::setItemStack);
            return true;
        }
        return false;
    };
    public static final TransactionOption<Boolean> DRY_RUN = (inventory, result, itemChangesMap) -> result.isAir();

    public T fill(AbstractInventory var1, ItemStack var2, Map<Integer, ItemStack> var3);

    default public T fill(TransactionType type, AbstractInventory inventory, ItemStack itemStack) {
        Pair<ItemStack, Map<Integer, ItemStack>> pair = type.process(inventory, itemStack);
        return this.fill(inventory, pair.left(), pair.right());
    }
}

