/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.inventory.click;

import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import net.minestom.server.entity.EquipmentSlot;
import net.minestom.server.entity.Player;
import net.minestom.server.event.EventDispatcher;
import net.minestom.server.event.inventory.InventoryClickEvent;
import net.minestom.server.inventory.AbstractInventory;
import net.minestom.server.inventory.PlayerInventory;
import net.minestom.server.inventory.TransactionType;
import net.minestom.server.inventory.click.ClickType;
import net.minestom.server.inventory.click.InventoryClickResult;
import net.minestom.server.item.ItemStack;
import net.minestom.server.item.Material;
import net.minestom.server.utils.MathUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class InventoryClickProcessor {
    public InventoryClickResult leftClick(ItemStack clicked, ItemStack cursor) {
        if (cursor.isSimilar(clicked)) {
            int totalAmount = cursor.amount() + clicked.amount();
            int maxSize = cursor.maxStackSize();
            if (!MathUtils.isBetween(totalAmount, 0, clicked.maxStackSize())) {
                cursor = cursor.withAmount(totalAmount - maxSize);
                clicked = clicked.withAmount(maxSize);
            } else {
                cursor = ItemStack.AIR;
                clicked = clicked.withAmount(totalAmount);
            }
        } else {
            ItemStack temp = clicked;
            clicked = cursor;
            cursor = temp;
        }
        return new InventoryClickResult(clicked, cursor);
    }

    public InventoryClickResult rightClick(ItemStack clicked, ItemStack cursor) {
        InventoryClickResult result = new InventoryClickResult(clicked, cursor);
        if (clicked.isSimilar(cursor)) {
            int amount = clicked.amount() + 1;
            if (!MathUtils.isBetween(amount, 0, clicked.maxStackSize())) {
                return result;
            }
            result.setCursor(cursor.withAmount(operand -> operand - 1));
            result.setClicked(clicked.withAmount(amount));
        } else if (cursor.isAir()) {
            int amount = (int)Math.ceil((double)clicked.amount() / 2.0);
            result.setCursor(clicked.withAmount(amount));
            result.setClicked(clicked.withAmount(operand -> operand / 2));
        } else if (clicked.isAir()) {
            result.setCursor(cursor.withAmount(operand -> operand - 1));
            result.setClicked(cursor.withAmount(1));
        } else {
            result.setCursor(clicked);
            result.setClicked(cursor);
        }
        return result;
    }

    public InventoryClickResult changeHeld(ItemStack clicked, ItemStack cursor) {
        return new InventoryClickResult(cursor, clicked);
    }

    public InventoryClickResult shiftClick(AbstractInventory inventory, AbstractInventory targetInventory, int start, int end, int step, Player player, int slot, ItemStack clicked, ItemStack cursor) {
        ItemStack currentItem;
        Material material;
        EquipmentSlot equipmentSlot;
        boolean craftingGridClick;
        InventoryClickResult clickResult = new InventoryClickResult(clicked, cursor);
        if (clicked.isAir()) {
            return clickResult.cancelled();
        }
        boolean bl = craftingGridClick = slot >= 36 && slot <= 40;
        if (inventory instanceof PlayerInventory && targetInventory instanceof PlayerInventory && (equipmentSlot = (material = clicked.material()).registry().equipmentSlot()) != null && (equipmentSlot.isArmor() || equipmentSlot == EquipmentSlot.OFF_HAND) && !craftingGridClick && (currentItem = player.getEquipment(equipmentSlot)).isAir()) {
            player.setEquipment(equipmentSlot, clicked);
            return new InventoryClickResult(ItemStack.AIR, cursor);
        }
        clickResult.setCancel(true);
        Pair<ItemStack, Map<Integer, ItemStack>> pair = TransactionType.ADD.process(targetInventory, clicked, (index, itemStack) -> {
            if (inventory == targetInventory && index == slot) {
                return false;
            }
            clickResult.setCancel(false);
            return true;
        }, start, end, step);
        ItemStack itemResult = pair.left();
        Map<Integer, ItemStack> itemChangesMap = pair.right();
        itemChangesMap.forEach((s, itemStack) -> {
            targetInventory.setItemStack((int)s, (ItemStack)itemStack);
            this.callClickEvent(player, targetInventory, (int)s, ClickType.SHIFT_CLICK, (ItemStack)itemStack, cursor);
        });
        clickResult.setClicked(itemResult);
        return clickResult;
    }

    @Nullable
    public ItemStack dragging(Player player, AbstractInventory inventory, List<Integer> slots, int button, ItemStack cursor) {
        if (button == 2) {
            int cursorAmount;
            int slotCount = slots.size();
            if (slotCount > (cursorAmount = cursor.amount())) {
                return null;
            }
            int slotSize = (int)((float)cursorAmount / (float)slotCount);
            int finalCursorAmount = cursorAmount;
            for (int slot : slots) {
                boolean isInWindow = slot < inventory.getSize();
                AbstractInventory inv = isInWindow ? inventory : player.getInventory();
                int s = isInWindow ? slot : slot - inventory.getSize();
                ItemStack slotItem = inv.getItemStack(s);
                int amount = slotItem.amount();
                if (cursor.isSimilar(slotItem)) {
                    if (MathUtils.isBetween(amount + slotSize, 0, slotItem.maxStackSize())) {
                        slotItem = slotItem.withAmount(a -> a + slotSize);
                        finalCursorAmount -= slotSize;
                    } else {
                        int maxSize = cursor.maxStackSize();
                        int removedAmount = maxSize - amount;
                        slotItem = slotItem.withAmount(maxSize);
                        finalCursorAmount -= removedAmount;
                    }
                } else if (slotItem.isAir()) {
                    slotItem = cursor.withAmount(slotSize);
                    finalCursorAmount -= slotSize;
                }
                inv.setItemStack(s, slotItem);
                this.callClickEvent(player, inv, s, ClickType.LEFT_DRAGGING, slotItem, cursor);
            }
            cursor = cursor.withAmount(finalCursorAmount);
        } else if (button == 6) {
            int cursorAmount = cursor.amount();
            if (slots.size() > cursorAmount) {
                return null;
            }
            int finalCursorAmount = cursorAmount;
            for (int slot : slots) {
                int s;
                boolean isInWindow = slot < inventory.getSize();
                AbstractInventory inv = isInWindow ? inventory : player.getInventory();
                ItemStack slotItem = inv.getItemStack(s = isInWindow ? slot : slot - inventory.getSize());
                if (cursor.isSimilar(slotItem)) {
                    int amount = slotItem.amount() + 1;
                    if (MathUtils.isBetween(amount, 0, slotItem.maxStackSize())) {
                        slotItem = slotItem.withAmount(amount);
                        --finalCursorAmount;
                    }
                } else if (slotItem.isAir()) {
                    slotItem = cursor.withAmount(1);
                    --finalCursorAmount;
                }
                inv.setItemStack(s, slotItem);
                this.callClickEvent(player, inv, s, ClickType.RIGHT_DRAGGING, slotItem, cursor);
            }
            cursor = cursor.withAmount(finalCursorAmount);
        }
        return cursor;
    }

    public InventoryClickResult doubleClick(AbstractInventory clickedInventory, AbstractInventory inventory, Player player, int slot, ItemStack clicked, ItemStack cursor) {
        InventoryClickResult clickResult = new InventoryClickResult(clicked, cursor);
        if (cursor.isAir()) {
            return clickResult.cancelled();
        }
        int amount = cursor.amount();
        int maxSize = cursor.maxStackSize();
        int remainingAmount = maxSize - amount;
        if (remainingAmount == 0) {
            return clickResult;
        }
        BiFunction<AbstractInventory, ItemStack, ItemStack> func = (inv, rest) -> {
            Pair<ItemStack, Map<Integer, ItemStack>> pair = TransactionType.TAKE.process((AbstractInventory)inv, (ItemStack)rest, (index, itemStack) -> index != slot || clickedInventory != inv);
            ItemStack itemResult = pair.left();
            Map<Integer, ItemStack> itemChangesMap = pair.right();
            itemChangesMap.forEach((s, itemStack) -> {
                inv.setItemStack((int)s, (ItemStack)itemStack);
                this.callClickEvent(player, (AbstractInventory)inv, (int)s, ClickType.DOUBLE_CLICK, (ItemStack)itemStack, cursor);
            });
            return itemResult;
        };
        ItemStack remain = cursor.withAmount(remainingAmount);
        PlayerInventory playerInventory = player.getInventory();
        if (Objects.equals(clickedInventory, inventory)) {
            if (!(remain = func.apply(inventory, remain)).isAir()) {
                remain = func.apply(playerInventory, remain);
            }
        } else if (clickedInventory == playerInventory) {
            if (!(remain = func.apply(playerInventory, remain)).isAir()) {
                remain = func.apply(inventory, remain);
            }
        } else {
            remain = func.apply(playerInventory, remain);
        }
        if (remain.isAir()) {
            clickResult.setCursor(cursor.withAmount(maxSize));
        } else {
            int tookAmount = remainingAmount - remain.amount();
            clickResult.setCursor(cursor.withAmount(amount + tookAmount));
        }
        return clickResult;
    }

    public InventoryClickResult drop(Player player, boolean all, int slot, ItemStack clicked, ItemStack cursor) {
        InventoryClickResult clickResult = new InventoryClickResult(clicked, cursor);
        if (slot == -999) {
            if (all) {
                int amount = cursor.amount();
                ItemStack dropItem = cursor.withAmount(amount);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    cursor = ItemStack.AIR;
                }
            } else {
                ItemStack dropItem = cursor.withAmount(1);
                boolean dropResult = player.dropItem(dropItem);
                clickResult.setCancel(!dropResult);
                if (dropResult) {
                    int amount = cursor.amount();
                    int newAmount = amount - 1;
                    cursor = cursor.withAmount(newAmount);
                }
            }
        } else if (all) {
            int amount = clicked.amount();
            ItemStack dropItem = clicked.withAmount(amount);
            boolean dropResult = player.dropItem(dropItem);
            clickResult.setCancel(!dropResult);
            if (dropResult) {
                clicked = ItemStack.AIR;
            }
        } else {
            ItemStack dropItem = clicked.withAmount(1);
            boolean dropResult = player.dropItem(dropItem);
            clickResult.setCancel(!dropResult);
            if (dropResult) {
                int amount = clicked.amount();
                int newAmount = amount - 1;
                clicked = clicked.withAmount(newAmount);
            }
        }
        clickResult.setClicked(clicked);
        clickResult.setCursor(cursor);
        return clickResult;
    }

    private void callClickEvent(Player player, AbstractInventory inventory, int slot, ClickType clickType, ItemStack clicked, ItemStack cursor) {
        EventDispatcher.call(new InventoryClickEvent(inventory, player, slot, clickType, clicked, cursor));
    }
}

