/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.Keyed;
import net.kyori.adventure.nbt.BinaryTag;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.util.RGBLike;
import net.minestom.server.MinecraftServer;
import net.minestom.server.adventure.MinestomDataComponentValue;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.Result;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.codec.Transcoder;
import net.minestom.server.component.DataComponent;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.component.DataComponents;
import net.minestom.server.item.ItemStackHashImpl;
import net.minestom.server.item.ItemStackImpl;
import net.minestom.server.item.Material;
import net.minestom.server.item.component.CustomData;
import net.minestom.server.item.component.CustomModelData;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.RegistryTranscoder;
import net.minestom.server.tag.Tag;
import net.minestom.server.tag.TagReadable;
import net.minestom.server.utils.Unit;
import net.minestom.server.utils.validate.Check;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface ItemStack
extends TagReadable,
DataComponent.Holder,
HoverEventSource<HoverEvent.ShowItem>
permits ItemStackImpl {
    public static final NetworkBuffer.Type<ItemStack> NETWORK_TYPE = ItemStackImpl.networkType(DataComponent.PATCH_NETWORK_TYPE);
    public static final NetworkBuffer.Type<ItemStack> UNTRUSTED_NETWORK_TYPE = ItemStackImpl.networkType(DataComponent.UNTRUSTED_PATCH_NETWORK_TYPE);
    public static final NetworkBuffer.Type<ItemStack> STRICT_NETWORK_TYPE = NETWORK_TYPE.transform(itemStack -> {
        Check.argCondition(itemStack.amount() == 0 || itemStack.isAir(), "ItemStack cannot be empty");
        return itemStack;
    }, itemStack -> {
        Check.argCondition(itemStack.amount() == 0 || itemStack.isAir(), "ItemStack cannot be empty");
        return itemStack;
    });
    public static final Codec<ItemStack> CODEC = new StructCodec<ItemStack>(){
        private static final StructCodec<ItemStack> DECODER = StructCodec.struct("id", Material.CODEC, ItemStack::material, "count", Codec.INT.optional(1), ItemStack::amount, "components", DataComponent.PATCH_CODEC.optional(DataComponentMap.EMPTY), ItemStack::componentPatch, ItemStack::of);
        private static final StructCodec<ItemStack> ENCODER = StructCodec.struct("id", Material.CODEC, ItemStack::material, "count", Codec.INT, ItemStack::amount, "components", DataComponent.PATCH_CODEC.optional(DataComponentMap.EMPTY), ItemStack::componentPatch, ItemStack::of);

        @Override
        public <D> Result<ItemStack> decodeFromMap(Transcoder<D> coder, Transcoder.MapLike<D> map) {
            return DECODER.decodeFromMap(coder, map);
        }

        @Override
        public <D> Result<D> encodeToMap(Transcoder<D> coder, ItemStack value, Transcoder.MapBuilder<D> map) {
            return ENCODER.encodeToMap(coder, value, map);
        }
    };
    public static final ItemStack AIR = new ItemStackImpl(Material.AIR, 0, DataComponentMap.EMPTY);

    @Contract(value="_ -> new", pure=true)
    public static Builder builder(Material material) {
        return new ItemStackImpl.Builder(material, 1);
    }

    @Contract(value="_ -> new", pure=true)
    public static ItemStack of(Material material) {
        return ItemStack.of(material, 1);
    }

    @Contract(value="_ ,_ -> new", pure=true)
    public static ItemStack of(Material material, int amount) {
        return ItemStackImpl.create(material, amount);
    }

    @Contract(value="_ ,_ -> new", pure=true)
    public static ItemStack of(Material material, DataComponentMap components) {
        return ItemStackImpl.create(material, 1, components);
    }

    @Contract(value="_ ,_, _ -> new", pure=true)
    public static ItemStack of(Material material, int amount, DataComponentMap components) {
        return ItemStackImpl.create(material, amount, components);
    }

    public static ItemStack fromItemNBT(CompoundBinaryTag nbtCompound) {
        RegistryTranscoder<BinaryTag> coder = new RegistryTranscoder<BinaryTag>(Transcoder.NBT, MinecraftServer.process());
        return (ItemStack)CODEC.decode(coder, nbtCompound).orElseThrow("Invalid NBT for ItemStack");
    }

    @Contract(pure=true)
    public Material material();

    @Contract(pure=true)
    public int amount();

    @Contract(pure=true)
    public DataComponentMap componentPatch();

    @Contract(value="_, -> new", pure=true)
    public ItemStack with(Consumer<Builder> var1);

    @Contract(value="_, -> new", pure=true)
    public ItemStack withMaterial(Material var1);

    @Contract(value="_, -> new", pure=true)
    public ItemStack withAmount(int var1);

    @Contract(value="_, -> new", pure=true)
    default public ItemStack withAmount(IntUnaryOperator intUnaryOperator) {
        return this.withAmount(intUnaryOperator.applyAsInt(this.amount()));
    }

    @Contract(value="_, _ -> new", pure=true)
    public <T> ItemStack with(DataComponent<T> var1, T var2);

    @Contract(value="_ -> new", pure=true)
    default public ItemStack with(DataComponent<Unit> component) {
        return this.with(component, Unit.INSTANCE);
    }

    default public <T> ItemStack with(DataComponent<T> component, UnaryOperator<T> operator) {
        T value = this.get(component);
        if (value == null) {
            return this;
        }
        return this.with(component, operator.apply(value));
    }

    @Contract(value="_, -> new", pure=true)
    public ItemStack without(DataComponent<?> var1);

    @Contract(value="_, -> new", pure=true)
    default public ItemStack withCustomName(Component customName) {
        return this.with(DataComponents.CUSTOM_NAME, customName);
    }

    @Contract(value="_, -> new", pure=true)
    default public ItemStack withLore(Component ... lore) {
        return this.with(DataComponents.LORE, List.of(lore));
    }

    @Contract(value="_, -> new", pure=true)
    default public ItemStack withLore(List<Component> lore) {
        return this.with(DataComponents.LORE, lore);
    }

    @Contract(value="_, -> new", pure=true)
    default public ItemStack withItemModel(String model) {
        return this.with(DataComponents.ITEM_MODEL, model);
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    default public ItemStack withCustomModelData(List<Float> floats, List<Boolean> flags, List<String> strings, List<RGBLike> colors) {
        return this.with(DataComponents.CUSTOM_MODEL_DATA, new CustomModelData(floats, flags, strings, colors));
    }

    @Contract(value="_ -> new", pure=true)
    default public ItemStack withGlowing(boolean glowing) {
        return this.with(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, glowing);
    }

    @Contract(value="-> new", pure=true)
    default public ItemStack withoutExtraTooltip() {
        return this.builder().hideExtraTooltip().build();
    }

    @Contract(pure=true)
    default public int maxStackSize() {
        return this.get(DataComponents.MAX_STACK_SIZE, 64);
    }

    @Contract(value="_ -> new", pure=true)
    default public ItemStack withMaxStackSize(int maxStackSize) {
        return this.with(DataComponents.MAX_STACK_SIZE, maxStackSize);
    }

    @Contract(value="_, _ -> new", pure=true)
    default public <T> ItemStack withTag(Tag<T> tag, @Nullable T value) {
        return this.with(DataComponents.CUSTOM_DATA, this.get(DataComponents.CUSTOM_DATA, CustomData.EMPTY).withTag(tag, value));
    }

    @Override
    @Contract(pure=true)
    default public <T> @UnknownNullability T getTag(Tag<T> tag) {
        return this.get(DataComponents.CUSTOM_DATA, CustomData.EMPTY).getTag(tag);
    }

    @Contract(value="_, -> new", pure=true)
    public ItemStack consume(int var1);

    @Contract(value="_, -> new", pure=true)
    public ItemStack damage(int var1);

    @Contract(pure=true)
    default public boolean isAir() {
        return this.material() == Material.AIR;
    }

    @Contract(pure=true)
    public boolean isSimilar(ItemStack var1);

    public Builder builder();

    public CompoundBinaryTag toItemNBT();

    @Override
    default public HoverEvent<HoverEvent.ShowItem> asHoverEvent(UnaryOperator<HoverEvent.ShowItem> op) {
        if (this.componentPatch().isEmpty()) {
            return HoverEvent.showItem((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.showItem(this.material(), this.amount())));
        }
        HashMap<Key, MinestomDataComponentValue> dataComponents = new HashMap<Key, MinestomDataComponentValue>();
        for (DataComponent.Value entry : this.componentPatch().entrySet()) {
            dataComponents.put(entry.component().key(), MinestomDataComponentValue.dataComponentValue(entry.value()));
        }
        return HoverEvent.showItem((HoverEvent.ShowItem)op.apply(HoverEvent.ShowItem.showItem((Keyed)this.material(), this.amount(), dataComponents)));
    }

    public static Collection<Component> textComponents(ItemStack itemStack) {
        Component itemName;
        ArrayList<Component> components = new ArrayList<Component>(itemStack.get(DataComponents.LORE, List.of()));
        Component displayName = itemStack.get(DataComponents.CUSTOM_NAME);
        if (displayName != null) {
            components.add(displayName);
        }
        if ((itemName = itemStack.get(DataComponents.ITEM_NAME)) != null) {
            components.add(itemName);
        }
        return List.copyOf(components);
    }

    public static ItemStack copyWithOperator(ItemStack itemStack, UnaryOperator<Component> operator) {
        return itemStack.with(DataComponents.CUSTOM_NAME, operator).with(DataComponents.ITEM_NAME, operator).with(DataComponents.LORE, lines -> {
            ArrayList translatedComponents = new ArrayList();
            lines.forEach(component -> translatedComponents.add((Component)operator.apply((Component)component)));
            return translatedComponents;
        });
    }

    public static sealed interface Builder
    permits ItemStackImpl.Builder {
        @Contract(value="_ -> this")
        public Builder material(Material var1);

        @Contract(value="_ -> this")
        public Builder amount(int var1);

        @Contract(value="_, _ -> this")
        public <T> Builder set(DataComponent<T> var1, T var2);

        @Contract(value="_ -> this")
        default public Builder set(DataComponent<Unit> component) {
            return this.set(component, Unit.INSTANCE);
        }

        @Contract(value="_ -> this")
        public Builder remove(DataComponent<?> var1);

        default public Builder customName(Component customName) {
            return this.set(DataComponents.CUSTOM_NAME, customName);
        }

        default public Builder lore(Component ... lore) {
            return this.set(DataComponents.LORE, List.of(lore));
        }

        default public Builder lore(List<Component> lore) {
            return this.set(DataComponents.LORE, lore);
        }

        default public Builder itemModel(String model) {
            return this.set(DataComponents.ITEM_MODEL, model);
        }

        default public Builder customModelData(List<Float> floats, List<Boolean> flags, List<String> strings, List<RGBLike> colors) {
            return this.set(DataComponents.CUSTOM_MODEL_DATA, new CustomModelData(floats, flags, strings, colors));
        }

        default public Builder glowing() {
            return this.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, Boolean.valueOf(true));
        }

        default public Builder glowing(boolean glowing) {
            return this.set(DataComponents.ENCHANTMENT_GLINT_OVERRIDE, Boolean.valueOf(glowing));
        }

        default public Builder maxStackSize(int maxStackSize) {
            return this.set(DataComponents.MAX_STACK_SIZE, Integer.valueOf(maxStackSize));
        }

        public Builder hideExtraTooltip();

        @Contract(value="_, _ -> this")
        public <T> Builder set(Tag<T> var1, @Nullable T var2);

        default public <T> void setTag(Tag<T> tag, @Nullable T value) {
            this.set(tag, value);
        }

        @Contract(value="-> new", pure=true)
        public ItemStack build();
    }

    public static sealed interface Hash
    permits ItemStackHashImpl.Air, ItemStackHashImpl.Item {
        public static final Hash AIR = new ItemStackHashImpl.Air();
        public static final NetworkBuffer.Type<Hash> NETWORK_TYPE = ItemStackHashImpl.NETWORK_TYPE;

        public static Hash of(ItemStack itemStack) {
            return ItemStackHashImpl.of(new RegistryTranscoder<Integer>(Transcoder.CRC32_HASH, MinecraftServer.process()), itemStack);
        }
    }
}

