/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item;

import java.util.Collection;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.key.KeyPattern;
import net.minestom.server.codec.Codec;
import net.minestom.server.component.DataComponentMap;
import net.minestom.server.component.DataComponents;
import net.minestom.server.instance.block.Block;
import net.minestom.server.item.MaterialImpl;
import net.minestom.server.item.Materials;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.registry.Registry;
import net.minestom.server.registry.RegistryData;
import net.minestom.server.registry.StaticProtocolObject;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public sealed interface Material
extends StaticProtocolObject<Material>,
Materials
permits MaterialImpl {
    public static final NetworkBuffer.Type<Material> NETWORK_TYPE = NetworkBuffer.VAR_INT.transform(Material::fromId, Material::id);
    public static final Codec<Material> CODEC = Codec.KEY.transform(Material::fromKey, Material::key);

    @Override
    @Contract(pure=true)
    public RegistryData.MaterialEntry registry();

    @Override
    default public Key key() {
        return this.registry().key();
    }

    @Override
    default public int id() {
        return this.registry().id();
    }

    default public boolean isBlock() {
        return this.registry().block() != null;
    }

    default public @UnknownNullability Block block() {
        return this.registry().block();
    }

    default public DataComponentMap prototype() {
        return this.registry().prototype();
    }

    default public boolean isArmor() {
        return this.registry().isArmor();
    }

    default public int maxStackSize() {
        return this.prototype().get(DataComponents.MAX_STACK_SIZE, 64);
    }

    public static Collection<Material> values() {
        return MaterialImpl.REGISTRY.values();
    }

    @Nullable
    public static Material fromKey(@KeyPattern String key) {
        return Material.fromKey(Key.key(key));
    }

    @Nullable
    public static Material fromKey(Key key) {
        return MaterialImpl.REGISTRY.get(key);
    }

    @Nullable
    public static Material fromId(int id) {
        return MaterialImpl.REGISTRY.get(id);
    }

    public static Registry<Material> staticRegistry() {
        return MaterialImpl.REGISTRY;
    }
}

