/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.item.Material;
import net.minestom.server.item.armor.TrimMaterialImpl;
import net.minestom.server.item.armor.TrimMaterials;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public sealed interface TrimMaterial
extends Holder.Direct<TrimMaterial>,
TrimMaterials
permits TrimMaterialImpl {
    public static final NetworkBuffer.Type<TrimMaterial> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.STRING, TrimMaterial::assetName, NetworkBuffer.STRING.mapValue(NetworkBuffer.STRING), TrimMaterial::overrideArmorMaterials, NetworkBuffer.COMPONENT, TrimMaterial::description, TrimMaterial::create);
    public static final Codec<TrimMaterial> REGISTRY_CODEC = StructCodec.struct("asset_name", Codec.STRING, TrimMaterial::assetName, "override_armor_materials", Codec.STRING.mapValue(Codec.STRING).optional(Map.of()), TrimMaterial::overrideArmorMaterials, "description", Codec.COMPONENT, TrimMaterial::description, TrimMaterial::create);
    public static final NetworkBuffer.Type<Holder<TrimMaterial>> NETWORK_TYPE = Holder.networkType(Registries::trimMaterial, REGISTRY_NETWORK_TYPE);
    public static final Codec<Holder<TrimMaterial>> CODEC = Holder.codec(Registries::trimMaterial, REGISTRY_CODEC);

    public static TrimMaterial create(String assetName, Map<String, String> overrideArmorMaterials, Component description) {
        return new TrimMaterialImpl(assetName, overrideArmorMaterials, description);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<TrimMaterial> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("trim_material"), REGISTRY_CODEC, RegistryData.Resource.TRIM_MATERIALS);
    }

    public String assetName();

    public Map<String, String> overrideArmorMaterials();

    public Component description();

    public static final class Builder {
        private String assetName;
        private Material ingredient;
        private final Map<String, String> overrideArmorMaterials = new HashMap<String, String>();
        private Component description;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        public Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        public Builder overrideArmorMaterials(Map<String, String> overrideArmorMaterials) {
            this.overrideArmorMaterials.putAll(overrideArmorMaterials);
            return this;
        }

        @Contract(value="_, _ -> this", pure=true)
        public Builder overrideArmorMaterial(String slot, String material) {
            this.overrideArmorMaterials.put(slot, material);
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        public Builder description(Component description) {
            this.description = description;
            return this;
        }

        @Contract(pure=true)
        public TrimMaterial build() {
            return new TrimMaterialImpl(this.assetName, this.overrideArmorMaterials, this.description);
        }
    }
}

