/*
 * Decompiled with CFR 0.152.
 */
package net.minestom.server.item.armor;

import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.minestom.server.codec.Codec;
import net.minestom.server.codec.StructCodec;
import net.minestom.server.item.armor.TrimPatternImpl;
import net.minestom.server.item.armor.TrimPatterns;
import net.minestom.server.network.NetworkBuffer;
import net.minestom.server.network.NetworkBufferTemplate;
import net.minestom.server.registry.DynamicRegistry;
import net.minestom.server.registry.Holder;
import net.minestom.server.registry.Registries;
import net.minestom.server.registry.RegistryData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public sealed interface TrimPattern
extends Holder.Direct<TrimPattern>,
TrimPatterns
permits TrimPatternImpl {
    public static final NetworkBuffer.Type<TrimPattern> REGISTRY_NETWORK_TYPE = NetworkBufferTemplate.template(NetworkBuffer.KEY, TrimPattern::assetId, NetworkBuffer.COMPONENT, TrimPattern::description, NetworkBuffer.BOOLEAN, TrimPattern::isDecal, TrimPattern::create);
    public static final Codec<TrimPattern> REGISTRY_CODEC = StructCodec.struct("asset_id", Codec.KEY, TrimPattern::assetId, "description", Codec.COMPONENT, TrimPattern::description, "decal", Codec.BOOLEAN, TrimPattern::isDecal, TrimPattern::create);
    public static final NetworkBuffer.Type<Holder<TrimPattern>> NETWORK_TYPE = Holder.networkType(Registries::trimPattern, REGISTRY_NETWORK_TYPE);
    public static final Codec<Holder<TrimPattern>> CODEC = Holder.codec(Registries::trimPattern, REGISTRY_CODEC);

    public static TrimPattern create(Key assetId, Component description, boolean decal) {
        return new TrimPatternImpl(assetId, description, decal);
    }

    public static Builder builder() {
        return new Builder();
    }

    @ApiStatus.Internal
    public static DynamicRegistry<TrimPattern> createDefaultRegistry() {
        return DynamicRegistry.create(Key.key("trim_pattern"), REGISTRY_CODEC, RegistryData.Resource.TRIM_PATTERNS);
    }

    public Key assetId();

    public Component description();

    public boolean isDecal();

    public static final class Builder {
        private Key assetId;
        private Component description;
        private boolean decal;

        private Builder() {
        }

        @Contract(value="_ -> this", pure=true)
        public Builder assetId(String assetId) {
            return this.assetId(Key.key(assetId));
        }

        @Contract(value="_ -> this", pure=true)
        public Builder assetId(Key assetId) {
            this.assetId = assetId;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        public Builder description(Component description) {
            this.description = description;
            return this;
        }

        @Contract(value="_ -> this", pure=true)
        public Builder decal(boolean decal) {
            this.decal = decal;
            return this;
        }

        @Contract(pure=true)
        public TrimPattern build() {
            return new TrimPatternImpl(this.assetId, this.description, this.decal);
        }
    }
}

